import type { ComponentKey, ControlObjectProps, FieldInternalValue, FieldKey } from '../component/types';
import type { Dict } from '@sage/xtrem-shared';
type UCPType<T extends ComponentKey> = ControlObjectProps<T> extends {
    getUiComponentProperties: (...args: any[]) => infer U;
} ? U : any;
export interface XtremUiTransactionEntry {
    value: any;
    hasChangedInTransaction: boolean;
}
export interface XtremUiTransaction {
    values: Dict<XtremUiTransactionEntry>;
    uiComponentProperties: Dict<XtremUiTransactionEntry>;
}
export declare const commitTransaction: (screenId: string) => void;
export declare const rollbackTransaction: (screenId: string) => void;
export declare const isTransactionInProgress: (screenId: string) => boolean;
export declare const getFieldValue: <T extends FieldKey>(screenId: string, elementId: string) => FieldInternalValue<T>;
export declare const setFieldValue: <T extends FieldKey>(screenId: string, elementId: string, newValue: FieldInternalValue<T>) => void;
export declare const getUiComponentProperties: <T extends ComponentKey>(screenId: string, elementId: string) => UCPType<T>;
export declare const setUiComponentProperties: <T extends ComponentKey>(screenId: string, elementId: string, newValue: Partial<ControlObjectProps<T>>) => void;
export declare const executeInReadOnlyTransaction: (callback: () => any) => any;
export {};
//# sourceMappingURL=transactions-service.d.ts.map