import { ContainerValidationErrorsComponent } from '../component/container/page/container-validation-errors';
import * as toastActions from '../redux/actions/toast-actions';
import { getStore } from '../redux/store';
import * as React from 'react';
export const PERMANENT_TOAST = Number.MIN_SAFE_INTEGER;
let toastId = 0;
export const showToast = (content, options = {}) => {
    toastId += 1;
    const language = options.language || 'markdown';
    if (language !== 'jsx' && typeof content !== 'string') {
        throw new Error(`Invalid toast content: jsx cannot be rendered in "${language}".`);
    }
    const toast = {
        content,
        id: toastId,
        language,
        isDismissed: false,
        timeout: options.timeout || 4000,
        type: options.type || 'info',
    };
    getStore().dispatch(toastActions.showToast(toast));
};
export const showContainerValidationToast = (pageMetadata, result) => {
    showToast(React.createElement(ContainerValidationErrorsComponent, { validationResults: result.allErrors, pageMetadata: pageMetadata, screenId: pageMetadata.screenId }), {
        type: 'error',
        language: 'jsx',
    });
};
export const removeToasts = () => {
    getStore().dispatch(toastActions.removeToasts());
};
//# sourceMappingURL=toast-service.js.map