export declare abstract class PromiseTracker {
    /** The number of tracked async operations which are currently executing */
    private static pendingPromisesCount;
    /** add the has-pending-promises element to the document */
    private static ensurePendingElementExists;
    private static deletePendingElementIfExists;
    private static pushPending;
    private static popPending;
    /**
     * This function is called when a dialog is open on the screen.
     *
     * Dialogs are tricky because they create a promise which is only resolved when the user closes the dialog.
     * We have to decrement pendingPromisesCount so that it can get back to 0 while the dialog is open.
     */
    static pushDialog(): void;
    /**
     * This function is called when a dialog is closed.
     *
     * We increment pendingPromisesCount to counter-balance what we pushDialog did earlier.
     */
    static popDialog(): void;
    /**
     * This function tracks the execution of an async operations
     *
     * It adds a hidden #has-pending-promises div element to the DOM at the beginning of the operation and
     * removes it when the operation completes.
     *
     * This div elements is used to wait on the completion of async operations (graphql API calls, refresh of components)
     * in our library of cucumber steps (see the waitForPromises() function in xtrem-cli)
     */
    static withTracker<T>(body: () => Promise<T>): Promise<T>;
}
//# sourceMappingURL=promise-tracker.d.ts.map