import * as XtremDateTime from '@sage/xtrem-date-time';
import type { LocalizeEnumFunction, LocalizeFunction } from '@sage/xtrem-shared';
import type { DatePropertyValue } from '../utils/types';
/**
 * This function will be either injected by the 'decoratorTransformer' (which wraps a specific set of decorators
 * properties) or can be used in any page or sticker for any string that has to be translated.
 * The translations will be fetched by the 'screen-loader-service' through the metadata endpoint based on
 * the browser's locale settings. Hence the 'localize' function simply relies on the state to fetch all translations.
 *
 * @export
 * @param {string} key the translation key
 * @param {string} value the translation default value
 * @returns {string} the translated string
 */
export declare const localize: LocalizeFunction;
export declare const localizeText: LocalizeFunction;
export declare const localizeEnumMember: LocalizeEnumFunction;
export declare const formatDateToCurrentLocale: (date: DatePropertyValue, fmt?: XtremDateTime.DatePresetFormat) => string;
export declare const formatNumberToCurrentLocale: (value: number | string, scale?: number) => string;
//# sourceMappingURL=i18n-service.d.ts.map