import type { ClientNode } from '@sage/xtrem-client';
import { type Dict } from '@sage/xtrem-shared';
import type { OptionsMenuItem, ReferenceProperties, TableProperties, TreeProperties } from '../../component/control-objects';
import type { PageDecoratorProperties } from '../../component/decorator-properties';
import type { PropertyValueType } from '../../component/field/reference/reference-types';
import type { NestedField, NestedFieldTypes } from '../../component/nested-fields';
import type { ComponentKey, OrderByType } from '../../component/types';
import type { UiComponentProperties } from '../../plugin';
import { type NodePropertyType } from '../../types';
import type { AggFunc } from '../collection-data-utils';
import type { GraphQLFilter, NodeCollection, QueryArguments, QueryBuilderOptions, QueryProperty, QueryWrapper } from '../graphql-utils';
import type { FormattedNodeDetails } from '../metadata-types';
import type { Page } from '../page';
import type { ScreenBase } from '../screen-base';
import type { ScreenBaseDefinition } from '../screen-base-definition';
export interface FieldQueryBuilderFunctionArgs {
    elementId: string;
    fieldProperties: UiComponentProperties;
    screenDefinition: ScreenBaseDefinition;
    nodeTypes?: Dict<FormattedNodeDetails>;
    node?: NodePropertyType;
}
export declare const getFieldProperties: (elementId: string, fieldType: ComponentKey, fieldProperties: UiComponentProperties, screenDefinition: ScreenBaseDefinition, bind?: PropertyValueType, nodeTypes?: Dict<FormattedNodeDetails>, node?: NodePropertyType) => QueryProperty;
/**
 * Create a GraphQL request fragment for a given field type.
 * The function checks the field type, and based on that calls the corresponding query builder function.
 *
 * @param fieldType
 * @param queryBuilderFunctionArgs
 * @returns
 */
export declare const getFieldPropertiesWithoutAlias: (fieldType: ComponentKey, queryBuilderFunctionArgs: FieldQueryBuilderFunctionArgs) => QueryProperty;
export interface BuildReferenceFieldQueryProps<T extends ClientNode = any> {
    after?: string;
    contextNode?: NodePropertyType;
    elementId: string;
    fieldProperties: Omit<ReferenceProperties<ScreenBase, T> | TableProperties<ScreenBase, T>, 'parent'>;
    filter?: GraphQLFilter<T>;
    group?: {
        key: string;
        value?: string;
        aggFunc?: AggFunc;
    };
    isFilterLimitedToDataset?: boolean;
    level?: number;
    nodeTypes?: Dict<FormattedNodeDetails>;
    /**
     * If it is an initial page load query for the navigation panel, the option menu is added to the query filter by this method.
     * In other cases (e.g. filter change, sorting change), the collection data service provided filter already contains the currently selected
     * option item.
     *  */
    optionMenuItem?: OptionsMenuItem;
    orderBy?: OrderByType<T>;
    pageSize?: number;
    parentElementId?: string;
    queryAlias?: string;
    recordContext?: Dict<any>;
    screenDefinition: ScreenBaseDefinition;
    screenId: string;
    valueField?: any;
}
export declare const buildTableQuery: ({ rootNodeId, elementId, columns, screenDefinition, queryArguments, bind, group, treeProperties, totalCount, node, nodeTypes, }: {
    rootNodeId: string;
    elementId: string;
    columns: NestedField<Page, NestedFieldTypes>[];
    screenDefinition: ScreenBaseDefinition;
    queryArguments?: QueryArguments;
    bind?: PropertyValueType;
    group?: {
        key: string;
        value?: string;
    };
    treeProperties?: TreeProperties<Page>;
    totalCount?: boolean;
    node?: string;
    nodeTypes?: Dict<FormattedNodeDetails>;
}) => NodeCollection;
export declare const buildNestedAggregationQuery: ({ group, rootNodeId, elementId, bind, }: {
    group: {
        key: string;
        value?: string;
    };
    rootNodeId: string;
    elementId: string;
    bind?: PropertyValueType;
}) => NodeCollection;
export declare const buildSimpleAggregationQuery: ({ contextNode, fieldNode, referenceProperties, group, isFilterLimitedToDataset, queryAlias, queryBuilderOptions, nodeTypes, }: {
    contextNode?: NodePropertyType;
    fieldNode: NodePropertyType;
    referenceProperties: ReferenceProperties;
    group?: {
        key: string;
        value?: string;
        aggFunc?: AggFunc;
    };
    isFilterLimitedToDataset?: boolean;
    queryAlias?: string;
    queryBuilderOptions: QueryBuilderOptions;
    nodeTypes?: Dict<FormattedNodeDetails>;
}) => {
    query: QueryWrapper<any>;
    bind?: string | null;
    fieldNode: NodePropertyType;
    node: NodePropertyType;
};
export declare function buildLookupsQuery({ contextNode, elementId, fieldNode, fieldProperties, level, nodeCollectionQuery, nodeTypes, parentElementId, queryAlias, recordContext, screenDefinition, screenId, screenProperties, }: {
    contextNode?: NodePropertyType;
    elementId: string;
    fieldNode: NodePropertyType;
    fieldProperties: Omit<ReferenceProperties | TableProperties, 'parent'>;
    level?: number;
    nodeCollectionQuery: NodeCollection;
    nodeTypes: Dict<FormattedNodeDetails>;
    parentElementId?: string;
    queryAlias?: string;
    recordContext?: Record<string, any>;
    screenDefinition: ScreenBaseDefinition;
    screenId: string;
    screenProperties: PageDecoratorProperties<any>;
}): {
    query: QueryWrapper<any>;
    bind?: string | null;
    fieldNode: NodePropertyType;
    node: NodePropertyType;
};
export declare function buildReferenceFieldQuery({ after, contextNode, elementId, fieldProperties, filter, group, isFilterLimitedToDataset, level, nodeTypes, optionMenuItem, orderBy, pageSize, parentElementId, queryAlias, recordContext, screenDefinition, screenId, }: BuildReferenceFieldQueryProps): {
    query: QueryWrapper<any>;
    bind?: string | null;
    fieldNode: NodePropertyType;
    node: NodePropertyType;
};
//# sourceMappingURL=field-query-builder.d.ts.map