import { getStore } from '../redux/store';
import * as focusActions from '../redux/actions/focus-actions';
import * as dirtyStateActions from '../redux/actions/dirty-state-actions';
import * as fieldValueActions from '../redux/actions/field-value-actions';
import { checkIfPageIsLoaded, getPageDefinitionFromState } from '../utils/state-utils';
import { fetchField } from './graphql-service';
import { getUiComponentProperties } from './transactions-service';
import { CollectionValue } from './collection-data-service';
export const isFieldDirty = (screenId, elementId) => getStore().getState().screenDefinitions[screenId].dirtyStates[elementId] || false;
export const setFieldDirty = (screenId, elementId) => {
    const dispatch = getStore().dispatch;
    dispatch(dirtyStateActions.setFieldDirty({ screenId, elementId }));
};
export const setFieldClean = (screenId, elementId) => {
    const dispatch = getStore().dispatch;
    dispatch(dirtyStateActions.setFieldClean({ screenId, elementId }));
};
export const refreshField = async ({ screenId, elementId, keepPageInfo = false, keepModifications = true, }) => {
    const store = getStore();
    const state = store.getState();
    const dispatch = getStore().dispatch;
    checkIfPageIsLoaded(screenId, state);
    const screenDefinition = state.screenDefinitions[screenId];
    const screenProperties = getUiComponentProperties(screenId, screenId);
    if (screenProperties.isTransient) {
        throw new Error('Cannot refresh fields on transient pages');
    }
    const fieldProps = getUiComponentProperties(screenId, elementId);
    if (fieldProps.isTransient) {
        throw new Error('Cannot refresh a transient field');
    }
    if (fieldProps.isTransientInput) {
        throw new Error('Cannot refresh a transient input field');
    }
    const queryParameters = screenDefinition.queryParameters || {};
    const id = queryParameters._id;
    if (!id) {
        throw new Error('Cannot refresh a field on an unloaded page');
    }
    const oldValue = state.screenDefinitions[screenId].values[elementId];
    const updatedValues = oldValue instanceof CollectionValue && keepModifications ? oldValue.getChangedRecords() : [];
    const newValue = await fetchField(screenDefinition, fieldProps, String(id), elementId, state.plugins, state.nodeTypes, elementId, keepPageInfo);
    if (oldValue instanceof CollectionValue && keepModifications) {
        newValue.updateMany(updatedValues);
    }
    if (oldValue !== newValue) {
        dispatch(fieldValueActions.setFieldValue(screenId, elementId, newValue, false));
    }
    return newValue;
};
export const focusField = (screenId, elementId) => {
    checkIfPageIsLoaded(screenId);
    const store = getStore();
    store.dispatch(focusActions.setFocusPosition(screenId, elementId));
};
export const isFieldInFocus = (screenId, elementId) => {
    checkIfPageIsLoaded(screenId);
    const state = getStore().getState();
    return state.focusPosition?.screenId === screenId && state.focusPosition?.elementId === elementId;
};
export const getFocussedField = (screenId) => {
    const state = getStore().getState();
    if (!state.focusPosition || state.focusPosition.screenId !== screenId || !state.focusPosition.elementId) {
        return null;
    }
    return getPageDefinitionFromState(screenId, state).metadata.controlObjects[state.focusPosition.elementId];
};
//# sourceMappingURL=field-state-service.js.map