import type { Dict } from '@sage/xtrem-shared';
import type { Store } from 'redux';
import * as xtremRedux from '../redux';
import type { CustomDialogContentType, CustomDialogOptions, DialogButton, DialogButtonOptions, DialogContentType, DialogLevel, DialogOptions, DialogType, IDialogControl, PageDialogOptions } from '../types/dialogs';
import type { QueryParameters } from '../utils/types';
/** For unit tests only */
export declare const resetDialogIds: () => void;
export declare class DialogControl implements IDialogControl {
    [Symbol.toStringTag]: string;
    readonly id: number;
    protected readonly dialogPromise: Promise<void>;
    private rejectPromise;
    private resolvePromise;
    constructor({ dialogId, screenId, level, title, content, getButtons, options, isSticker, isDirtyCheck, subtitle, type, }: {
        dialogId: number;
        screenId: string | null;
        level: DialogLevel;
        title: string | undefined;
        content: DialogContentType;
        getButtons: (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>;
        options?: PageDialogOptions & CustomDialogOptions;
        isSticker?: boolean;
        isDirtyCheck: boolean;
        subtitle?: string;
        readonly type?: DialogType;
    });
    cancel(): void;
    catch(callback: (dialogId: number) => any): Promise<any>;
    then<TResult1 = any, TResult2 = any>(onFulfilled?: ((value: any) => TResult1 | PromiseLike<TResult1>) | undefined | null, onRejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): Promise<TResult1 | TResult2>;
    finally(onFinally?: (() => void) | null | undefined): Promise<any>;
    resolve(value: Dict<any>): void;
}
export declare class PageDialogControl extends DialogControl {
    [Symbol.toStringTag]: string;
    constructor(dialogId: number, options?: PageDialogOptions);
    resolve(value: Dict<any>): void;
    finally(onFinally?: (() => void) | null | undefined): Promise<any>;
    get promise(): Promise<void>;
}
export declare const closeDialog: (dialogId: number, result?: any, isWizardCompleted?: boolean) => Promise<void>;
export declare const createDialog: <T extends DialogOptions = DialogOptions>(screenId: string, level: DialogLevel, title: string | undefined, content: DialogContentType, getButtons: (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>, options?: T, isSticker?: boolean, type?: DialogType) => DialogControl;
export declare const createStickerDialog: (store: Store<xtremRedux.XtremAppState, xtremRedux.AppAction>, screenId: string, level: DialogLevel, title: string | undefined, content: DialogContentType, options?: CustomDialogOptions) => DialogControl;
export declare const getDialogButton: (dialogId: number, callback: (value: any) => void, defaultText: string, buttonConfiguration?: DialogButtonOptions) => DialogButton;
export declare const getAcceptButton: (dialogId: number, resolve: (value?: any) => void, buttonConfiguration?: DialogButtonOptions) => DialogButton;
export declare const getCancelButton: (dialogId: number, callback: (reason?: any) => void, buttonConfiguration?: DialogButtonOptions) => DialogButton;
export declare const getConfirmationButtons: (options?: DialogOptions) => (dialogId: number, resolve: (value?: any) => void, reject: (reason?: any) => void) => Dict<DialogButton>;
export declare const errorDialog: (screenId: string, title: string, error: Error) => void;
export declare const confirmationDialog: (screenId: string, level: DialogLevel, title: string, message: string, options?: DialogOptions) => DialogControl;
export declare const messageDialog: (screenId: string, level: DialogLevel, title: string | undefined, message: string, options?: DialogOptions) => DialogControl;
export declare const customDialog: (screenId: string, level: DialogLevel, content: CustomDialogContentType, options?: CustomDialogOptions) => DialogControl;
export declare function resolvePageDialog(resolutionValue: any): void;
export declare const pageDialog: <T>(store: Store<xtremRedux.XtremAppState, xtremRedux.AppAction>, path: string, queryParameters?: QueryParameters, options?: PageDialogOptions) => Promise<void | T>;
export declare const openPageDialog: <T>(path: string, queryParameters?: QueryParameters, options?: PageDialogOptions) => Promise<void | T>;
//# sourceMappingURL=dialog-service.d.ts.map