/**
 * This service updates the page definitions to include user defined custom fields, which are loaded to the product
 * from the `customFields` page metadata property
 */
import { type Dict, type MetaCustomField } from '@sage/xtrem-shared';
import type { NestedField } from '../component/nested-fields';
import type { ComponentKey } from '../component/types';
import type { Constructible } from '../types';
import type { Page } from './page';
import type { PageMetadata } from './page-metadata';
import type { FormattedNodeDetails } from './metadata-types';
export declare const addCustomFieldsToPageBody: (nodeTypes: Dict<FormattedNodeDetails>, pageMetadata: PageMetadata, pageConstructor: Constructible<Page>) => void;
export declare const componentsWithLookup: ComponentKey[];
export declare const addCustomColumnToNestedFields: (contextNode: string, nodeTypes: Dict<FormattedNodeDetails>, currentNestedFields: NestedField<any, any>[], elementId: string, componentType: ComponentKey, onlyInsertIfFound: boolean, customFields?: Dict<MetaCustomField[]>) => void;
export declare const getCustomFields: (contextNode: string, nodeTypes: Dict<FormattedNodeDetails>, currentNestedFields: NestedField<any, any>[], elementId: string, componentType: ComponentKey, customFields?: Dict<MetaCustomField[]>, onlyInsertIfFound?: boolean) => NestedField<any, any>[];
export declare const isCustomFieldReadOnly: (nodeTypes: Dict<FormattedNodeDetails>, nodeName: string, bind: string) => boolean;
export declare function calculateDeepPaths(propertyPath: string): {
    subpath: string[];
    selectorSegments: string[];
    mainSegments: string[];
    alias: string;
};
//# sourceMappingURL=customization-service.d.ts.map