import type { ClientNode } from '@sage/xtrem-client';
import type { Dict, FiltrableType } from '@sage/xtrem-shared';
import type { CancelToken } from 'axios';
import type { Unsubscribe } from 'redux';
import type { OptionsMenuItem, TableOptionsMenuItem, TableProperties } from '../component/control-objects';
import type { PropertyValueType } from '../component/field/reference/reference-types';
import type { ServerRecordMapperFunction } from '../component/field/traits';
import type { NestedField, NestedFieldTypes } from '../component/nested-fields';
import type { OrderByType, PartialCollectionValue, PartialCollectionValueWithIds } from '../component/types';
import type { TableValidationError } from '../component/ui/nested-field-errors-component';
import type { NodePropertyType } from '../types';
import type { MakeRequired } from '../utils/types';
import type { AggregationMethod, CollectionGlobalValidationState, CollectionValueFieldPropertiesWithAdditionalRecords, FetchNestedGridArgs, InternalValue, NormalizedCollection, ValidityChangeSubscriptionCallback, ValueChangeSubscriptionCallback } from './collection-data-types';
import { CollectionFieldTypes, RecordActionType } from './collection-data-types';
import { type AggFunc } from './collection-data-utils';
import type { Filter } from './filter-service';
import type { GraphQLFilter } from './graphql-utils';
import { LokiDb } from './loki';
import type { FormattedNodeDetails } from './metadata-types';
import type { PageDefinition } from './page-definition';
import type { ScreenBase } from './screen-base';
import type { ValidationResult } from './screen-base-definition';
export interface GridLodable extends Omit<CollectionValueFieldPropertiesWithAdditionalRecords, 'selectedRecords'> {
}
interface GetPageParams<T extends ClientNode = any> {
    axiosCancelToken?: CancelToken;
    cleanMetadata?: boolean;
    cursor?: string;
    fetchPageSize?: number;
    filters?: Filter<FiltrableType>[];
    group?: {
        key: string;
        value?: string;
        aggFunc?: AggFunc;
    };
    groups?: any;
    level?: number;
    orderBy?: OrderByType;
    pageNumber?: number;
    pageSize?: number;
    parentId?: string;
    rawFilter?: GraphQLFilter;
    searchText?: string;
    selectedOptionsMenuItem?: TableOptionsMenuItem<T>;
    tableFieldProperties: GridLodable;
    totalCount?: boolean;
}
export declare class CollectionValue<T extends ClientNode = any> {
    protected initialFilter: Array<GraphQLFilter<T> | undefined>;
    protected filter: Array<Record<number, GraphQLFilter<T>>>;
    /**
     * Stores a filter snapshot whenever a search text is combined with
     * active filters (i.e. nav panel in split view)
     * so that it can be later restored by calling "restoreFilterSnapshot"
     */
    private readonly filterSnapshot;
    protected forceRefetch: boolean;
    protected lastFetchedPage: Array<Record<number, number>>;
    protected orderBy: Array<Record<number, OrderByType>>;
    protected initialOrderBy: Array<OrderByType | undefined>;
    protected activeOptionsMenuItem?: TableOptionsMenuItem<T>;
    protected readonly columnDefinitions: Array<NestedField<ScreenBase, NestedFieldTypes>[]>;
    protected readonly db: LokiDb<T>;
    protected readonly bind?: PropertyValueType | string;
    readonly elementId: string;
    protected readonly fieldType?: CollectionFieldTypes;
    protected readonly isTransient: boolean;
    protected readonly isNoServerLookups: boolean;
    protected readonly levelMap?: Record<number, (keyof T & string) | undefined>;
    protected readonly nodeTypes: Dict<FormattedNodeDetails>;
    protected readonly parentElementId?: string;
    protected readonly recordContext?: Dict<any>;
    readonly screenId: string;
    protected readonly locale: string;
    protected readonly valueChangeSubscribers: ValueChangeSubscriptionCallback[];
    protected readonly valueChangeUncommittedSubscribers: ValueChangeSubscriptionCallback[];
    protected readonly validityChangeSubscribers: ValidityChangeSubscriptionCallback[];
    protected readonly validityChangeUncommittedSubscribers: ValidityChangeSubscriptionCallback[];
    protected readonly mapServerRecordFunctions?: (ServerRecordMapperFunction | undefined)[];
    protected readonly sublevelProperty?: string | null;
    hasNextPage: boolean;
    readonly initialValues: PartialCollectionValue<T>[];
    readonly nodes: string[];
    readonly contextNode?: string;
    /** Level which is used when the collection value is in a lookup dialog that belongs to a nested grid */
    readonly referenceLookupContextLevel?: number;
    private creatingNewPhantomRowPromise;
    private unCommittedCreatingNewPhantomRowPromise;
    private readonly forbiddenKeys;
    constructor({ activeOptionsMenuItem, bind, columnDefinitions, contextNode, dbKey, elementId, fieldType, filter, hasNextPage, initialValues, isNoServerLookups, isTransient, levelMap, locale, mapServerRecordFunctions, nodes, nodeTypes, orderBy, parentElementId, recordContext, screenId, referenceLookupContextLevel, sublevelProperty, }: {
        activeOptionsMenuItem?: TableOptionsMenuItem<T>;
        bind?: PropertyValueType | string;
        columnDefinitions: Array<NestedField<ScreenBase, NestedFieldTypes, T>[]>;
        contextNode?: NodePropertyType;
        dbKey?: string;
        elementId: string;
        fieldType?: CollectionFieldTypes;
        filter?: Array<GraphQLFilter<T> | undefined>;
        hasNextPage: boolean;
        initialValues: PartialCollectionValue<T>[];
        isNoServerLookups?: boolean;
        isTransient: boolean;
        levelMap?: Record<number, (keyof T & string) | undefined>;
        locale?: string;
        mapServerRecordFunctions?: (ServerRecordMapperFunction | undefined)[];
        nodes: string[];
        nodeTypes?: Dict<FormattedNodeDetails>;
        orderBy?: Array<OrderByType | undefined>;
        parentElementId?: string;
        recordContext?: Dict<any>;
        referenceLookupContextLevel?: number;
        screenId: string;
        sublevelProperty?: string | null;
    });
    getPhantomRecords({ level, parentId, }?: {
        level?: number;
        parentId?: string;
    }): Promise<PartialCollectionValueWithIds<T>[]>;
    hasDirtyPhantomRows(): boolean;
    calculateAggregatedValue({ aggregationMethod, aggregationKey, level, parentId, where, includeUnloaded, includePhantom, isUncommitted, }: {
        aggregationMethod: AggregationMethod;
        aggregationKey: string;
        level?: number | null;
        parentId?: string | null;
        where?: LokiQuery<InternalValue<T> & LokiObj>;
        includeUnloaded?: boolean;
        includePhantom?: boolean;
        isUncommitted?: boolean;
        cleanMetadata?: boolean;
    }): number;
    getDefaultPhantomRow({ level }?: {
        level?: number;
    }): Promise<any>;
    resetRowToDefaults({ id, level, parentId, shouldNotifySubscribers, isOrganicChange, resetDirtiness, }: {
        id: string;
        level?: number;
        parentId?: string;
        shouldNotifySubscribers?: boolean;
        isOrganicChange?: boolean;
        resetDirtiness?: boolean;
    }): Promise<void>;
    createNewPhantomRow({ level, parentId, shouldNotifySubscribers, cleanMetadata, isUncommitted, }?: {
        level?: number;
        parentId?: string;
        shouldNotifySubscribers?: boolean;
        cleanMetadata?: boolean;
        isUncommitted?: boolean;
    }): Promise<PartialCollectionValueWithIds<T>>;
    resetPhantomRowToDefault(): Promise<void>;
    createRecord(args: Parameters<NormalizedCollection<T>['createRecord']>[0]): InternalValue<T>;
    commitPhantomRow({ id, level, parentId, shouldNotifySubscribers, }: {
        id: string;
        level?: number;
        parentId?: string;
        shouldNotifySubscribers?: boolean;
    }): void;
    protected getTreeFromNormalizedCollection({ records, includeActions, excludeEmptyChildCollections, isRequestingDefaults, removeNegativeId, cleanInputTypes, }: {
        records: InternalValue<T>[];
        includeActions?: boolean;
        excludeEmptyChildCollections?: boolean;
        isRequestingDefaults?: boolean;
        removeNegativeId?: boolean;
        cleanInputTypes?: boolean;
    }): any[];
    protected formatRecordValue: (collectionItem: Partial<InternalValue<T>>, previousRecord?: Partial<InternalValue<T>>, shouldCallRemapServer?: boolean, level?: number) => any;
    private getOrderBy;
    private getFilter;
    private getInternalFilter;
    resetFilter(): void;
    fetchInvalidUnloadedRecords(): Promise<void>;
    private isReferenceField;
    protected fetchServerRecords({ pageDefinition, pageSize, tableFieldProperties, group, axiosCancelToken, level, parentId, cursor, totalCount, }: {
        pageDefinition: PageDefinition;
        tableFieldProperties: GridLodable;
        pageSize: number;
        group?: {
            key: string;
            value?: string;
            aggFunc?: AggFunc;
        };
        axiosCancelToken?: CancelToken;
        level?: number;
        parentId?: string;
        cursor?: string;
        totalCount?: boolean;
    }): Promise<any>;
    /** Compacts query results with __ aliases into a single object for better rendering and data management purposes */
    repackRecordData: (recordValue: PartialCollectionValue<T> | Omit<PartialCollectionValue<T>, '_id'> | Partial<InternalValue<T>>) => InternalValue<T>;
    protected notifyValueChangeSubscribers(type: RecordActionType, recordValue: Partial<InternalValue<T>>, isUncommitted?: boolean): void;
    getErrorMessages({ records, fieldProperties, withoutServerErrors, }?: {
        records?: InternalValue<T>[];
        fieldProperties?: MakeRequired<TableProperties, 'mainField'>;
        withoutServerErrors?: boolean;
    }): TableValidationError[];
    getAllInvalidRecords({ level, parentId, }?: {
        level?: number | null;
        parentId?: string | null;
    }): InternalValue<T>[];
    getInvalidUnloadedRecords({ level, parentId, withoutServerErrors, }?: {
        level?: number | null;
        parentId?: string | null;
        withoutServerErrors?: boolean;
    }): InternalValue<T>[];
    getInvalidLoadedRecords({ level, parentId, withoutServerErrors, }?: {
        level?: number | null;
        parentId?: string | null;
        withoutServerErrors?: boolean;
    }): InternalValue<T>[];
    fetchAllErrors(): Promise<void>;
    validateField: ({ skipDispatch, withoutServerErrors, }?: {
        skipDispatch?: boolean;
        withoutServerErrors?: boolean;
    }) => Promise<ValidationResult[]>;
    getErrorList: (errors: TableValidationError[]) => ValidationResult[];
    isValueEmpty: (value: any) => boolean;
    protected hasMultipleLevels(): boolean;
    getValidationStateByColumn(): CollectionGlobalValidationState;
    protected notifyValidationSubscribers(recordsWithChangedValidationStatus: InternalValue<T>[], isUncommitted?: boolean): void;
    protected getUpdatedRecord({ previous, newData, toBeMarkedAsDirty, addToDirty, }: {
        previous: InternalValue<T>;
        newData: InternalValue<T>;
        toBeMarkedAsDirty?: string[];
        addToDirty?: string[];
    }): InternalValue<T>;
    getChangedRecords(): any[];
    updateMany(records: any[]): void;
    protected findAndUpdate({ recordData, level, shouldNotifySubscribers, upsert, toBeMarkedAsDirty, resetRecordAction, isOrganicChange, changedColumnId, isUncommitted, }: {
        recordData: PartialCollectionValue<T>;
        level?: number;
        shouldNotifySubscribers?: boolean;
        upsert?: boolean;
        toBeMarkedAsDirty?: string[];
        resetRecordAction?: boolean;
        isOrganicChange?: boolean;
        changedColumnId?: string;
        isUncommitted?: boolean;
    }): InternalValue<T> | null;
    protected addQueryResultToCollection({ result, level, markAsAdded, parentId, group, }: {
        result: any;
        level?: number;
        markAsAdded?: boolean;
        parentId?: string;
        group?: {
            key: string;
            value?: string;
            aggFunc?: AggFunc;
        };
    }): InternalValue<T>[];
    /** For data to be used in control objects without lokiJs metadata */
    getRawRecords(): any[];
    getFormattedActiveRecords: () => any[];
    /** For data to be used in control objects without lokiJs metadata */
    getRawRecord(args: {
        cleanMetadata: undefined;
        id: string;
        includeUnloaded?: boolean;
        level?: number;
        temporaryRecords?: PartialCollectionValueWithIds<T>[];
        isUncommitted?: boolean;
    }): InternalValue<T> & LokiObj;
    getRawRecord(args: {
        cleanMetadata?: false;
        id: string;
        includeUnloaded?: boolean;
        level?: number;
        temporaryRecords?: PartialCollectionValueWithIds<T>[];
        isUncommitted?: boolean;
    }): InternalValue<T> & LokiObj;
    getRawRecord(args: {
        cleanMetadata?: true;
        id: string;
        includeUnloaded?: boolean;
        level?: number;
        temporaryRecords?: PartialCollectionValueWithIds<T>[];
        isUncommitted?: boolean;
    }): PartialCollectionValueWithIds<T>;
    getRawRecord(args: {
        cleanMetadata?: boolean;
        id: string;
        includeUnloaded?: boolean;
        level?: number;
        isUncommitted?: boolean;
    }): (InternalValue<T> & LokiObj) | PartialCollectionValueWithIds<T>;
    /** Find a record based on a property's value */
    getRawRecordByFieldValue({ fieldName, fieldValue, level, includeUnloaded, }: {
        fieldName: string;
        fieldValue: any;
        level?: number;
        includeUnloaded?: boolean;
    }): PartialCollectionValueWithIds<T> | null;
    getAncestorIds(args: {
        id: string;
        level?: number;
    }): string[];
    protected getNestedRecordsRecursive({ parentId, level, cb, }: {
        parentId: string;
        level: number;
        cb?: (record: Partial<InternalValue<T>>) => Partial<InternalValue<T>>;
    }): any;
    getRecordWithChildren({ id, level, isUncommitted, cleanMetadata, cb, }: {
        id: string;
        level?: number;
        isUncommitted?: boolean;
        cleanMetadata?: boolean;
        cb?: (record: Partial<InternalValue<T>>) => Partial<InternalValue<T>>;
    }): PartialCollectionValueWithIds<T> | null;
    getRecordByIdAndLevel(args: {
        id: string;
        level?: number;
    }): InternalValue<T>;
    cleanCollectionData(): void;
    fetchNestedGrid({ rootNode, selectedRecordId, level, levelProps, queryArguments, childProperty, }: FetchNestedGridArgs): Promise<InternalValue<T>[]>;
    getNestedGrid({ level, parentId }: {
        level: number;
        parentId: string;
    }): InternalValue<T>[];
    getFilteredSortedRecords({ pageSize, pageNumber, group, limit, level, cleanMetadata, parentId, temporaryRecords, }: {
        pageSize: number;
        pageNumber: number;
        group?: {
            key: string;
            value?: string;
            aggFunc?: AggFunc;
        };
        limit?: number;
        level?: number;
        cleanMetadata?: boolean;
        parentId?: string;
        temporaryRecords?: PartialCollectionValueWithIds<T>[];
    }): any;
    generateIndex(): string;
    getActiveOptionsMenuItem(): OptionsMenuItem | undefined;
    getPageWithCurrentQueryArguments({ pageNumber, pageSize, tableFieldProperties, group, level, parentId, cleanMetadata, cursor, totalCount, }: {
        tableFieldProperties: GridLodable;
        pageSize: number;
        pageNumber: number;
        group?: {
            key: string;
            value?: string;
            aggFunc?: AggFunc;
        };
        level?: number;
        parentId?: string;
        cleanMetadata?: boolean;
        cursor?: string;
        totalCount?: boolean;
    }): Promise<any[]>;
    getRecordWithCurrentQueryArguments({ pageNumber, pageSize, tableFieldProperties, group, level, parentId, cursor, cleanMetadata, }: {
        tableFieldProperties: GridLodable;
        pageSize: number;
        pageNumber: number;
        group?: {
            key: string;
            value?: string;
            aggFunc?: AggFunc;
        };
        level?: number;
        parentId?: string;
        cursor?: string;
        cleanMetadata?: boolean;
    }): Promise<any[]>;
    getPage({ axiosCancelToken, cleanMetadata, cursor, fetchPageSize, filters, group, level, orderBy: order, pageNumber, pageSize, parentId, rawFilter, searchText: text, selectedOptionsMenuItem, tableFieldProperties, totalCount, }: GetPageParams): Promise<any[]>;
    getPagesIteratively({ axiosCancelToken, cleanMetadata, cursor, fetchPageSize, filters, group, level, orderBy: order, pageSize, parentId, rawFilter, searchText: text, selectedOptionsMenuItem, tableFieldProperties, totalCount, }: GetPageParams): Promise<any[]>;
    private takeFilterSnapshot;
    restoreFilterSnapshot(): void;
    private getFetchServerRecordsOptions;
    private getFilteredSortedAndTemporaryRecords;
    subscribeForValueChanges(callback: ValueChangeSubscriptionCallback, isUncommitted?: boolean): Unsubscribe;
    subscribeForValidityChanges(callback: ValidityChangeSubscriptionCallback, isUncommitted?: boolean): Unsubscribe;
    runValidationOnRecord: ({ recordData, changedColumnId, isUncommitted, columnsToRevalidate, }: {
        recordData: InternalValue<T>;
        changedColumnId?: string;
        isUncommitted?: boolean;
        columnsToRevalidate?: string[];
    }) => Promise<Dict<ValidationResult>>;
    getIdPathToNestedRecord(id: string, level: number): string[];
    validate(): Promise<ValidationResult[]>;
    /**
     * This function adds external validation errors directly to the collection without running the client side rules. It is used to push server generated
     * errors to the records. Listener toast events are batched together and executed at the end to optimize performance and reduce the number of
     * rendering cycles.
     */
    addValidationErrors({ validationErrors, shouldNotifySubscribers, }: {
        validationErrors: ValidationResult[];
        shouldNotifySubscribers?: boolean;
    }): Promise<void>;
    getMergedValue({ recordId, columnId, value, level, toBeMarkedAsDirty, addToDirty, isUncommitted, }: {
        recordId: string;
        columnId: string;
        value: any;
        level?: number;
        isOrganicChange?: boolean;
        toBeMarkedAsDirty?: string[];
        addToDirty?: string[];
        isUncommitted?: boolean;
    }): PartialCollectionValueWithIds<T>;
    setCellValue({ recordId, columnId, value, level, isOrganicChange, toBeMarkedAsDirty, addToDirty, isUncommitted, shouldFetchDefault, }: {
        recordId: string;
        columnId: string;
        value: any;
        level?: number;
        isOrganicChange?: boolean;
        toBeMarkedAsDirty?: string[];
        addToDirty?: string[];
        isUncommitted?: boolean;
        shouldFetchDefault?: boolean;
    }): Promise<PartialCollectionValueWithIds<T>>;
    addOrUpdateRecordValue({ recordData, shouldNotifySubscribers, level, parentId, includeUnloaded, }: {
        recordData: PartialCollectionValueWithIds<T> | PartialCollectionValue<T> | InternalValue<T>;
        shouldNotifySubscribers?: boolean;
        level?: number;
        parentId?: string;
        includeUnloaded?: boolean;
    }): PartialCollectionValueWithIds<T>;
    setRecordValue({ recordData, shouldNotifySubscribers, level, upsert, toBeMarkedAsDirty, resetRecordAction, isOrganicChange, changedColumnId, isUncommitted, }: {
        recordData: PartialCollectionValueWithIds<T>;
        shouldNotifySubscribers?: boolean;
        level?: number;
        upsert?: boolean;
        toBeMarkedAsDirty?: string[];
        resetRecordAction?: boolean;
        isOrganicChange?: boolean;
        changedColumnId?: string;
        isUncommitted?: boolean;
    }): void;
    protected addNestedLevelRecursive({ recordData, action, dirty, level, parentId, shouldNotifySubscribers, }: {
        action?: RecordActionType | 'none';
        dirty?: boolean;
        level: number;
        parentId: string;
        recordData: InternalValue<T>;
        shouldNotifySubscribers: boolean;
    }): void;
    addRecord({ recordData, level, shouldNotifySubscribers, parentId, cleanMetadata, action, isUncommitted, dirty, }: {
        recordData: PartialCollectionValue<T> | Omit<PartialCollectionValue<T>, '_id'>;
        level?: number;
        shouldNotifySubscribers?: boolean;
        parentId?: string;
        cleanMetadata?: boolean;
        action?: RecordActionType | 'none';
        isUncommitted?: boolean;
        dirty?: boolean;
    }): PartialCollectionValueWithIds<T>;
    removeRecord({ recordId, shouldNotifySubscribers, level, includeUnloaded, }: {
        recordId: string;
        shouldNotifySubscribers?: boolean;
        level?: number;
        includeUnloaded?: boolean;
    }): void;
    getData({ cleanMetadata, includePhantom, inGroup, isUncommitted, level, limit, noLimit, parentId, temporaryRecords, where, }?: {
        cleanMetadata?: boolean;
        includePhantom?: boolean;
        inGroup?: boolean;
        isUncommitted?: boolean;
        level?: number;
        limit?: number;
        noLimit?: boolean;
        parentId?: string | null;
        temporaryRecords?: PartialCollectionValueWithIds<T>[];
        where?: LokiQuery<InternalValue<T> & LokiObj>;
    }): any[];
    getAllDataAsTree({ excludeEmptyChildCollections, cleanInputTypes, }?: {
        excludeEmptyChildCollections?: boolean;
        cleanInputTypes?: boolean;
    }): any[];
    /** Creates a change dataset understood by the server */
    getChangedRecordsAsTree({ excludeEmptyChildCollections, }?: {
        excludeEmptyChildCollections?: boolean;
    }): any[];
    /** Creates a change dataset understood by the server */
    getNormalizedChangedRecords(isRequestingDefaults?: boolean): any[];
    /** Gets all new records */
    getNewRecords(): any[];
    refreshRecord({ recordId, level, skipUpdate, }: {
        recordId: string;
        level?: number;
        skipUpdate?: boolean;
    }): Promise<any>;
    startRecordTransaction({ recordId, recordLevel }: {
        recordId: string;
        recordLevel?: number;
    }): void;
    commitRecord({ recordId, recordLevel, }: {
        recordId: string;
        recordLevel?: number;
    }): PartialCollectionValueWithIds<T>;
    cancelRecordTransaction({ recordId, recordLevel }: {
        recordId: string;
        recordLevel?: number;
    }): void;
    private getRecordByOffset;
    getNextRecord({ recordId, recordLevel, tableProperties, }: {
        recordId: string;
        recordLevel?: number;
        tableProperties: TableProperties;
    }): Promise<PartialCollectionValueWithIds<T> | null>;
    getPreviousRecord({ recordId, recordLevel, }: {
        recordId: string;
        recordLevel?: number;
    }): Promise<PartialCollectionValueWithIds<T> | null>;
    getParentNodeAndParentIdFromChildNode({ node }: {
        node: string;
    }): {
        childLevel: number;
        parentNode?: string;
        parentId?: string;
        parentBind?: string;
    };
    private readonly getNode;
    readonly getColumnDefinitions: (level?: number | null) => NestedField<ScreenBase, NestedFieldTypes, T>[];
}
export {};
//# sourceMappingURL=collection-data-service.d.ts.map