import type { AccessStatus, LocalizeLocale } from '@sage/xtrem-shared';
import * as React from 'react';
import type { NestedField, NestedFieldHandlersArguments, NestedFieldTypes } from '../component/nested-fields';
import type { ReadonlyFieldProperties } from '../component/readonly-field-control-object';
import type { FocusPosition } from '../redux/state';
import type { ScreenBase } from '../service/screen-base';
import type { ValidationResult } from '../service/screen-base-definition';
import type { ContextType, NestedRecordId, NodePropertyType } from '../types';
import type { QueryParameters } from '../utils/types';
export interface NestedFieldWrapperContextProps {
    _id: NestedRecordId;
    contextType?: ContextType;
    contextNode?: NodePropertyType;
    handlersArguments?: NestedFieldHandlersArguments;
    screenId: string;
    parentElementId: string;
    setFieldValue: (bind: string, value: any) => Promise<void>;
    recordContext?: any;
}
export interface NestedFieldWrapperExternalProps extends NestedFieldWrapperContextProps {
    columnDefinition: NestedField<ScreenBase, NestedFieldTypes>;
    columnName: string;
    columnProperties: ReadonlyFieldProperties;
    focusPosition?: FocusPosition | null;
    isParentReadOnly?: boolean;
    nestedReadOnlyField?: boolean;
    shouldRenderLabelInNestedReadOnlyMode?: boolean;
    validate?: (columnName: string, value: any) => Promise<ValidationResult[]>;
    validationErrors?: ValidationResult[];
    value: any;
}
export interface NestedFieldWrapperProps extends NestedFieldWrapperExternalProps {
    focusPosition?: FocusPosition | null;
    accessRule?: AccessStatus;
    locale: LocalizeLocale;
    onFocus: (screenId: string, elementId: string, row: string, nestedField: string) => void;
    navigate: (path: string, queryParameters?: QueryParameters) => void;
    updateNestedFieldValidationErrors: (screenId: string, elementId: string, errors: ValidationResult[], columnName: string, recordId?: string) => void;
}
export declare class NestedFieldWrapper extends React.Component<NestedFieldWrapperProps> {
    removeNonNestedErrors: (_bind: string) => undefined;
    validate: (columnName: string, value: any) => Promise<ValidationResult[]>;
    renderElement(): JSX.Element | undefined;
    render(): React.ReactNode;
}
export declare const ConnectedNestedFieldWrapper: import("react-redux").ConnectedComponent<typeof NestedFieldWrapper, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<NestedFieldWrapper> | undefined;
    columnDefinition: NestedField<ScreenBase, NestedFieldTypes>;
    columnName: string;
    columnProperties: ReadonlyFieldProperties;
    focusPosition?: FocusPosition | null | undefined;
    isParentReadOnly?: boolean | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    validate?: ((columnName: string, value: any) => Promise<ValidationResult[]>) | undefined;
    validationErrors?: ValidationResult[] | undefined;
    value: any;
    _id: NestedRecordId;
    contextType?: ContextType | undefined;
    contextNode?: NodePropertyType | undefined;
    handlersArguments?: NestedFieldHandlersArguments | undefined;
    screenId: string;
    parentElementId: string;
    setFieldValue: (bind: string, value: any) => Promise<void>;
    recordContext?: any;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=nested-field-wrapper.d.ts.map