import produce from 'immer';
import { getLocalStorage } from '../../utils/window';
import { ActionType } from '../action-types';
// QUESTION: This reducer is extremely confusing and does not match the common redux patterns. Is
//           this code really correct?
export const userCustomizations = (state = {}, action) => produce(state, (nextState) => {
    const localStorage = getLocalStorage();
    switch (action.type) {
        case ActionType.SetUserCustomizations:
            return action.value;
        case ActionType.UpdateUserCustomization:
            const stateScreen = nextState[action.value.screenId] || {};
            // eslint-disable-next-line no-param-reassign
            nextState[action.value.screenId] = stateScreen;
            action.value.userCustomizations.forEach(userCustomization => {
                const stateComponent = stateScreen[userCustomization.componentId] || {};
                stateScreen[userCustomization.componentId] = stateComponent;
                stateComponent[userCustomization.propertyName] = userCustomization.propertyValue;
            });
            localStorage.setItem('userCustomizations', JSON.stringify(nextState));
            return nextState;
        default:
            return nextState;
    }
});
//# sourceMappingURL=user-customizations.js.map