import { ActionType } from '../action-types';
export const sidebar = (state = null, action) => {
    if (action.type === ActionType.CloseTableSidebar || action.type === ActionType.SetPath) {
        return null;
    }
    if (action.type === ActionType.SetTableSidebarLoading) {
        return { ...state, isLoading: action.value };
    }
    if (action.type === ActionType.SetTableSidebarRecord) {
        if (!state?.elementId || !state?.screenId) {
            throw new Error('Cannot select record if sidebar is not open');
        }
        return {
            ...state,
            hasNextRecord: action.value.hasNextRecord,
            hasPreviousRecord: action.value.hasPreviousRecord,
            isLoading: false,
            isNewRecord: action.value.isNewRecord,
            level: action.value.level,
            recordId: action.value._id,
        };
    }
    if (action.type === ActionType.OpenTableSidebar) {
        return { ...action.value, isLoading: true };
    }
    return state;
};
//# sourceMappingURL=sidebar.js.map