import { ActionType } from '../action-types';
export const loading = (state = { globalLoading: false, pages: {}, widgets: {}, loadingDashboards: false }, action) => {
    switch (action.type) {
        case ActionType.SetGlobalLoading:
            return { ...state, globalLoading: action.value };
        case ActionType.SetLoadingDashboards:
            return { ...state, loadingDashboards: action.value.isLoading };
        case ActionType.SetValues:
            return { ...state, globalLoading: false };
        case ActionType.SetComponentLoading:
            return {
                ...state,
                pages: {
                    ...state.pages,
                    [action.value.screenId]: state.pages[action.value.screenId]
                        ? { ...state.pages[action.value.screenId], [action.value.elementId]: action.value.isLoading }
                        : { [action.value.elementId]: action.value.isLoading },
                },
            };
        case ActionType.SetWidgetLoading:
            return {
                ...state,
                widgets: {
                    ...state.widgets,
                    [action.value.widgetId]: action.value.isLoading,
                },
            };
        default:
            return state;
    }
};
//# sourceMappingURL=loading.js.map