import { combineReducers } from 'redux';
import { activeDialogs } from './active-dialogs';
import { activeLookupDialog } from './current-lookup-dialog';
import { applicationContext } from './application-context';
import { applicationPackages } from './application-packages';
import { browser } from './browser';
import { customizationWizardPage } from './customization-wizard-page';
import { dashboard } from './dashboard';
import { dataTypes } from './data-types';
import { enumTypes } from './enum-types';
import { exportConfigurationPage } from './export-configuration-page';
import { focusPosition } from './focus-position';
import { isKeyboardShortcutsEnabled } from './is-keyboard-shortcuts-enabled';
import { loading } from './loading';
import { menuItems } from './menu-items';
import { nodeTypes } from './node-type';
import { path } from './path';
import { plugins } from './plugins';
import { printingSettings } from './printing-settings';
import { screenDefinitions } from './screen-definitions';
import { serviceOptions } from './service-options';
import { sidebar } from './sidebar';
import { toasts } from './toasts';
import { translations } from './translations';
import { userCustomizations } from './user-customizations';
import { workflowNodes } from './workflow-nodes';
const rootReducer = combineReducers({
    activeDialogs,
    activeLookupDialog,
    applicationContext,
    applicationPackages,
    browser,
    customizationWizardPage,
    dashboard,
    dataTypes,
    enumTypes,
    exportConfigurationPage,
    focusPosition,
    isKeyboardShortcutsEnabled,
    loading,
    menuItems,
    nodeTypes,
    path,
    plugins,
    printingSettings,
    screenDefinitions,
    serviceOptions,
    sidebar,
    toasts,
    translations,
    userCustomizations,
    workflowNodes,
});
export default rootReducer;
//# sourceMappingURL=index.js.map