import { ActionType } from '../action-types';
import { combineReducers } from 'redux';
import { availableDashboards, dashboards, widgets } from './dashboard-group';
import { dashboardEditor } from './dashboard-editor';
import { widgetEditor } from './widget-editor';
export const nodeNames = (state = {}, action) => {
    if (action.type === ActionType.SetNodeNames) {
        return action.value;
    }
    return state;
};
export const widgetCategories = (state = {}, action) => {
    if (action.type === ActionType.SetWidgetCategories) {
        return action.value.categories;
    }
    return state;
};
export const canEditDashboards = (state = false, action) => {
    if (action.type === ActionType.SetInitialDashboardInformation) {
        return action.value.canEditDashboards;
    }
    return state;
};
const dashboardGroup = combineReducers({
    availableDashboards,
    dashboardEditor,
    dashboards,
    widgetEditor,
    widgets,
});
export const dashboardGroups = (state = {}, action) => {
    const group = action?.value?.group;
    if (group) {
        return {
            ...state,
            [group]: dashboardGroup(state[group], action),
        };
    }
    // The clear widget option action is a special case where we need to clear all widgets in all groups
    if (action.type === ActionType.ClearWidgetOptions) {
        return Object.keys(state).reduce((prevValue, currentValue) => {
            return { ...prevValue, [currentValue]: dashboardGroup(state[currentValue], action) };
        }, {});
    }
    return state;
};
export const dashboard = combineReducers({
    nodeNames,
    widgetCategories,
    dashboardGroups,
    canEditDashboards,
});
//# sourceMappingURL=dashboard.js.map