import { isDevMode } from '../../utils/window';
import { isNoConsole } from '../../utils/console';
const consoleFormat = 'color: green; font-weight: bold;';
export const loggingMiddleware = ({ getState }) => (next) => (action) => {
    if (isDevMode() && !isNoConsole()) {
        const id = Date.now();
        const state = getState();
        if (isDevMode()) {
            console.log('%cDispatching', consoleFormat, id, action);
            console.log('%cState before dispatch', consoleFormat, id, state);
        }
        const returnValue = next(action);
        const updatedState = getState();
        if (isDevMode()) {
            console.log('%cState after dispatch', consoleFormat, id, updatedState);
        }
        window.__XTREM_STATE = updatedState;
        return returnValue;
    }
    return next(action);
};
//# sourceMappingURL=logging-middleware.js.map