import { xtremConsole } from '../../utils/console';
import { isDevMode } from '../../utils/window';
const subscriptions = [];
export const getSubscriptions = () => [...subscriptions];
export const subscribeToActions = (subscription) => {
    subscriptions.push(subscription);
    return () => {
        const index = subscriptions.indexOf(subscription);
        if (index !== -1) {
            subscriptions.splice(index, 1);
        }
    };
};
export const actionSubscriptionMiddleware = () => (next) => (action) => {
    subscriptions.forEach(s => {
        try {
            s(action);
        }
        catch (e) {
            if (isDevMode()) {
                xtremConsole.error(e);
            }
        }
    });
    return next(action);
};
//# sourceMappingURL=action-subscription-middleware.js.map