import { ActionType } from '../action-types';
export const setFieldValidationErrors = (screenId, elementId, errors) => ({
    type: ActionType.SetErrors,
    value: { screenId, elementId, errors: Array.isArray(errors) ? errors : [errors] },
});
export const removeNonNestedErrors = (screenId, elementId) => ({
    type: ActionType.RemoveNonNestedError,
    value: { screenId, elementId },
});
export const updateNestedFieldValidationErrors = (screenId, elementId, validationErrors, columnId, recordId) => ({
    type: ActionType.UpdateNestedFieldErrors,
    value: { screenId, elementId, validationErrors, columnId, recordId },
});
export const updateNestedFieldValidationErrorsForRecord = ({ screenId, elementId, validationErrors, recordId, isUncommitted = false, level, }) => ({
    type: ActionType.UpdateNestedFieldRecordErrors,
    value: { screenId, elementId, validationErrors, recordId, level, isUncommitted },
});
export const setPageValidationErrors = (screenId, validationErrors) => ({ type: ActionType.UpdateErrors, value: { screenId, validationErrors } });
export const addInternalError = (screenId, elementId, errorMessage) => ({
    type: ActionType.AddInternalError,
    value: { screenId, elementId, errorMessage },
});
export const removeInternalError = (screenId, elementId) => ({
    type: ActionType.RemoveInternalError,
    value: { screenId, elementId },
});
export const removePageServerErrors = (screenId) => ({
    type: ActionType.RemovePageServerErrors,
    value: { screenId },
});
export const removePhantomErrors = (screenId, elementId) => ({
    type: ActionType.RemovePhantomError,
    value: { screenId, elementId },
});
//# sourceMappingURL=validation-actions.js.map