import type { Dict } from '@sage/xtrem-shared';
import type { OptionsMenuItem } from '../../component/control-objects';
import type { AppThunkDispatch } from '../action-types';
import type { TableViewGrouping, TableViewSortedColumn, XtremAppState } from '../state';
export declare const refreshNavigationPanel: (screenId: string, recordAdded?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export declare const setNavigationPanelIsHidden: (isHidden: boolean, screenId: string) => (dispatch: AppThunkDispatch) => void;
export declare const setNavigationPanelIsOpened: (isOpened: boolean, screenId: string) => (dispatch: AppThunkDispatch) => void;
export declare const setNavigationPanelIsHeaderHidden: (isHeaderHidden: boolean, screenId: string) => (dispatch: AppThunkDispatch) => void;
export declare const setTableViewColumnHidden: (screenId: string, elementId: string, level: number, columnHidden?: Dict<boolean>) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const setTableViewColumnOrder: (screenId: string, elementId: string, level: number, columnOrder?: string[]) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const setTableViewFilter: (screenId: string, elementId: string, level: number, filter?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const setTableViewGrouping: (screenId: string, elementId: string, level: number, grouping?: TableViewGrouping) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const setTableViewOptionMenuItem: (screenId: string, elementId: string, level: number, optionsMenuItem?: OptionsMenuItem) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const setTableViewOptionsMenuItemAndViewFilter: (screenId: string, elementId: string, level: number, optionsMenuItem?: OptionsMenuItem, filter?: any) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const setTableViewSearchText: (screenId: string, elementId: string, level: number, searchText: string) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
export declare const clearNavigationPanelSearchText: (screenId: string) => (dispatch: AppThunkDispatch) => void;
export declare const setTableViewSortOrder: (screenId: string, elementId: string, level: number, sortOrder?: TableViewSortedColumn[]) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => void;
//# sourceMappingURL=navigation-panel-actions.d.ts.map