import type { Changeable as fieldValueActions } from '../../component/field/traits';
import type { XtremUiPlugin } from '../../service/plugin-service';
import type { ScreenBaseDefinition } from '../../service/screen-base-definition';
import type { AppThunkDispatch } from '../action-types';
import type { XtremAppState } from '../state';
import type { Dict } from '@sage/xtrem-shared';
import type { NestedField, NestedFieldTypes } from '../../component/nested-fields';
import type { QueryArguments } from '../../service/graphql-utils';
import type { ScreenBase } from '../../service/screen-base';
import type { PropertyValueType } from '../../component/field/reference/reference-types';
import type { FormattedNodeDetails } from '../../service/metadata-types';
export declare const setFieldValue: (screenId: string, elementId: string, fieldValue: any, isOrganicChange?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
export interface ApplyDefaultValuesArgs {
    dispatch: AppThunkDispatch;
    screenDefinition: ScreenBaseDefinition<any>;
    fieldProperties?: fieldValueActions<any>;
    plugins: Dict<XtremUiPlugin>;
    nodeTypes: Dict<FormattedNodeDetails>;
    requestedFieldIds?: string[];
    skipDispatch?: boolean;
}
export declare const applyDefaultValues: ({ dispatch, screenDefinition, fieldProperties, plugins, nodeTypes, requestedFieldIds, skipDispatch, }: ApplyDefaultValuesArgs) => Promise<any>;
export interface DispatchDefaultValuesSetArgs {
    screenDefinition: ScreenBaseDefinition<any>;
    plugins: Dict<XtremUiPlugin>;
    nodeTypes: Dict<FormattedNodeDetails>;
    defaultValues: Dict<any>;
    dispatch?: AppThunkDispatch;
    skipDispatch?: boolean;
}
export declare const dispatchDefaultValuesSet: ({ screenDefinition, plugins, nodeTypes, defaultValues, dispatch, skipDispatch, }: DispatchDefaultValuesSetArgs) => any;
export declare const loadCollectionData: (screenId: string, elementId: string, nestedFields: NestedField<ScreenBase, NestedFieldTypes>[], queryArguments: QueryArguments, bind?: PropertyValueType, keepAllRecords?: boolean) => (dispatch: AppThunkDispatch, getState: () => XtremAppState) => Promise<void>;
//# sourceMappingURL=field-value-actions.d.ts.map