import type { Dict } from '@sage/xtrem-shared';
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import { type LoadMoreRowsParams } from '../../service/dashboard-service';
import { BaseDeveloperApi } from '../../service/screen-base';
import type { DashboardContextVariables } from '../dashboard-types';
import type { WidgetValueOrCallback } from './widget-utils';
export interface DashboardWidgetHeaderAction<W extends AbstractWidget> {
    onClick: (this: W) => void;
    title: string;
    icon?: IconType;
}
export interface DashboardWidgetFooterAction<W extends AbstractWidget> {
    onClick: (this: W) => void;
    title: string;
}
export declare enum WidgetCacheLifespan {
    hour = 3600000,
    day = 86400000,
    noCache = -1
}
export interface CallToActionDefinition<W extends AbstractWidget> {
    title: WidgetValueOrCallback<W, string>;
    isDisabled?: WidgetValueOrCallback<W, boolean>;
    isHidden?: WidgetValueOrCallback<W, boolean>;
    onClick: (this: W) => void;
}
export interface WithContent<W extends AbstractWidget, C = any> {
    content?: WidgetValueOrCallback<W, C[]>;
}
export interface AbstractWidgetDecorator<W extends AbstractWidget> {
    /** Title of the widget */
    title: WidgetValueOrCallback<W, string>;
    /** Default category that is used to organize the widgets in groups on the left list, it is passed onto the dashboard manager which provides a user friendly title. */
    category?: string;
    /** Description of the widget */
    description?: string;
    /** The widget group that the widget is available for the user to use. If not specified, the widget is available on the home page. */
    group?: string;
    /** GraphQL query that is used to fetch data for the widget. */
    getQuery: (this: W, queryParams?: LoadMoreRowsParams) => string | object;
    headerActions?: DashboardWidgetHeaderAction<W>[];
    footerActions?: DashboardWidgetFooterAction<W>[];
    /**
     * Used to cache the query result of the widget, defaults to a day
     */
    cacheLifespan?: WidgetCacheLifespan;
    /**
     * An xtrem page url where the end user can define settings for a given widget
     */
    settingsPage?: string;
    callToActions?: Dict<CallToActionDefinition<W>>;
}
export declare enum WidgetType {
    barChart = "barChart",
    contactCard = "contactCard",
    gauge = "gauge",
    indicatorTile = "indicatorTile",
    lineChart = "lineChart",
    pieChart = "pieChart",
    staticContent = "staticContent",
    table = "table",
    visualProcess = "visualProcess"
}
export interface WidgetDefinition<WidgetOptions extends Record<string, any> = {}> {
    _id: string;
    properties: AbstractWidgetDecorator<any>;
    artifactName: string;
    widgetObject: AbstractWidget<any, WidgetOptions>;
    data?: any;
    widgetType: WidgetType;
    /**
     * Unlike settings, the widget options are not saved, it's only for the duration of the page load. These contain things such as selected items, filter and sorting options
     */
    options?: WidgetOptions;
}
export declare class WidgetDeveloperApi<T = any, WidgetOptions extends Record<string, any> = {}> extends BaseDeveloperApi {
    private readonly parentWidget;
    private readonly widgetId;
    private readonly dashboardId;
    private readonly group;
    private readonly _contextVariables?;
    constructor(parentWidget: AbstractWidget<T, any>, widgetId: string, dashboardId: string, group: string, _contextVariables?: DashboardContextVariables | undefined);
    refreshWidget(): void;
    get data(): T | null;
    get contextVariables(): DashboardContextVariables | null;
    get settings(): any;
    get options(): WidgetOptions | Partial<WidgetOptions>;
    set options(newOptions: WidgetOptions);
}
export declare abstract class AbstractWidget<T = any, WidgetOptions extends Record<string, any> = {}> {
    private readonly _$;
    constructor();
    get $(): WidgetDeveloperApi<T, WidgetOptions>;
}
//# sourceMappingURL=abstract-widget.d.ts.map