import { type Dict, type Property } from '@sage/xtrem-shared';
import * as React from 'react';
import type { UserCustomizableWidget, UserWidgetDefinition } from '../../redux/state';
import type { DashboardContextVariables } from '../dashboard-types';
export interface WidgetEditorStepProps {
    contextVariables?: DashboardContextVariables;
    group: string;
    locale: string;
    nodeNames: Dict<string>;
    onWidgetDefinitionUpdated: (newData: UserWidgetDefinition) => void;
    stepIndex: number;
    widgetDefinition: UserWidgetDefinition;
}
export interface WidgetEditorStep {
    key: WidgetEditorStepType;
    title: string;
}
export type StepStatus = 'complete' | 'current' | 'incomplete';
export declare const DEFAULT_CHART_COLORS: {
    label: string;
    value: string;
}[];
export interface WidgetStepDefinition {
    title: string;
    isValid: (uwd: UserWidgetDefinition) => boolean;
}
export type WidgetEditorStepType = 'BASIC_INFO' | 'DATA' | 'CONTENT' | 'FILTERS' | 'SORTING' | 'LAYOUT';
/** This most be a function and cannot be a const, as the localize function must be called when the widget editor is
 * being opened to enure that the strings were loaded.
 * */
export declare const getWidgetEditorSteps: () => Dict<WidgetStepDefinition>;
export declare const stepsForWidgetTypes: Record<UserCustomizableWidget, WidgetEditorStepType[]>;
export declare function isChart(widgetDefinition: UserWidgetDefinition): boolean;
export declare const getStepStatus: (availableSteps: string[], activeStep: string, step: string) => StepStatus;
export declare const PropertyTableHeader: React.FC;
export declare const getPropertyParentNode: ({ property, nodeNames, widgetDefinition, }: {
    property: Property;
    nodeNames: Dict<string>;
    widgetDefinition: UserWidgetDefinition;
}) => string;
export declare const getWidgetDefaultSize: ({ type, columns }: UserWidgetDefinition) => {
    w: number;
    h: number;
};
//# sourceMappingURL=widget-editor-utils.d.ts.map