import * as React from 'react';
import type { Dict, Locale } from '@sage/xtrem-shared';
import type { UserWidgetDefinition } from '../../redux/state';
import type { DashboardContextVariables } from '../dashboard-types';
export interface WidgetEditorDialogExternalProps {
    group: string;
    contextVariables?: DashboardContextVariables;
}
export interface WidgetEditorDialogProps extends WidgetEditorDialogExternalProps {
    isDirty: boolean;
    isNewWidget: boolean;
    isOpen: boolean;
    locale: Locale;
    nodeNames: Dict<string>;
    onClose: () => void;
    onFinish: () => void;
    onUpdateWidgetSettings: (widgetDefinition: UserWidgetDefinition) => void;
    onWidgetDefinitionUpdated: (widgetDefinition: UserWidgetDefinition) => void;
    widgetDefinition: UserWidgetDefinition;
}
export declare function WidgetEditorDialog({ contextVariables, group, isDirty, isNewWidget, isOpen, locale, nodeNames, onClose, onFinish, onWidgetDefinitionUpdated, widgetDefinition, }: WidgetEditorDialogProps): React.ReactElement;
export declare const ConnectedWidgetEditorDialog: import("react-redux").ConnectedComponent<typeof WidgetEditorDialog, {
    group: string;
    contextVariables?: DashboardContextVariables | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
//# sourceMappingURL=widget-editor-dialog.d.ts.map