import { AbstractWidget } from '../widgets/abstract-widget';
import { barChart } from '../widgets/bar-chart-widget-decorator';
import { lineChart } from '../widgets/line-chart-widget-decorator';
import { ChartWidgetQueryBuilder } from './chart-widget-query-builder';
import { getCallToActionsFromWidgetDefinition } from './generic-widget-utils';
export const createGenericChartWidgetDefinition = (userWidgetDefinition, dashboardId, widgetId, group, contextVariables, isPreview = false) => {
    const queryBuilder = new ChartWidgetQueryBuilder(userWidgetDefinition);
    const callToActions = getCallToActionsFromWidgetDefinition(userWidgetDefinition, queryBuilder.getFilterObject(), isPreview);
    if (!userWidgetDefinition.xAxis) {
        throw new Error('Cannot create chart without an X axis.');
    }
    if (!userWidgetDefinition.aggregations || userWidgetDefinition.aggregations.length === 0) {
        throw new Error('Cannot create chart without a series.');
    }
    const chartAgrs = {
        primaryAxis: {
            bind: userWidgetDefinition.xAxis.property.id,
            title: userWidgetDefinition.xAxis.property.label,
        },
        primaryAxisLabel: userWidgetDefinition.horizontalAxisLabel,
        secondaryAxisLabel: userWidgetDefinition.verticalAxisLabel,
        secondaryAxes: userWidgetDefinition.aggregations.map(a => {
            return {
                bind: `${a.id}.${a.groupingMethod}`,
                title: a.title,
                color: a.color,
                tooltipContent(_, __, value) {
                    return String(value);
                },
            };
        }),
        title() {
            return userWidgetDefinition.title || '';
        },
        callToActions,
        content() {
            return queryBuilder.getValue(this.$.data);
        },
        getQuery(queryArgs) {
            return queryBuilder.build(queryArgs);
        },
    };
    class GenericChartWidget extends AbstractWidget {
    }
    if (userWidgetDefinition.type === 'BAR_CHART') {
        barChart(chartAgrs)(GenericChartWidget);
    }
    else if (userWidgetDefinition.type === 'LINE_CHART') {
        lineChart(chartAgrs)(GenericChartWidget);
    }
    GenericChartWidget.prototype.__id = widgetId;
    GenericChartWidget.prototype.__dashboardId = dashboardId;
    GenericChartWidget.prototype.__group = group;
    GenericChartWidget.prototype.__contextVariables = contextVariables;
    return new GenericChartWidget();
};
//# sourceMappingURL=generic-chart-widget.js.map