import * as React from 'react';
import { connect } from 'react-redux';
import { XtremTabs } from '../component/ui/tabs/xtrem-tabs';
import * as xtremRedux from '../redux';
import { localize } from '../service/i18n-service';
const CREATE_ACTION_TAB_ID = '$create';
export function DashboardSelectionTabs({ availableDashboards, onCreateDialogOpen, selectedDashboardId, setSelectedDashboard, canChangeTabs, }) {
    const [selectedTabId, setSelectedTabId] = React.useState(selectedDashboardId || null);
    React.useEffect(() => {
        setSelectedTabId(selectedDashboardId || null);
    }, [selectedDashboardId]);
    if (!availableDashboards?.length) {
        return null;
    }
    const onTabsChange = async (tabId) => {
        if (onCreateDialogOpen && tabId === CREATE_ACTION_TAB_ID) {
            onCreateDialogOpen();
            return;
        }
        if (canChangeTabs) {
            try {
                await canChangeTabs();
            }
            catch (_err) {
                // We return here if the promise is rejected
                return;
            }
        }
        setSelectedTabId(tabId);
        setSelectedDashboard(tabId);
    };
    return (React.createElement("div", { className: "e-dashboard-selection-tab-container", "data-testid": "e-dashboard-selection-tab-container" },
        React.createElement(XtremTabs, { onTabChange: onTabsChange, selectedTabId: selectedTabId || availableDashboards[0]._id, tabs: (availableDashboards || []).map(d => ({
                id: d._id,
                title: d.title,
            })) })));
}
export const ConnectedDashboardSelectionTabs = connect((state, props) => {
    const dashboardGroup = state.dashboard.dashboardGroups[props.group];
    if (!dashboardGroup) {
        return {
            ...props,
            availableDashboards: [],
            setSelectedDashboard: xtremRedux.actions.actionStub,
        };
    }
    const selectedDashboardId = Object.values(dashboardGroup.dashboards).find(s => s.isSelected)?._id;
    const availableDashboards = state.dashboard.canEditDashboards &&
        props.onCreateDialogOpen &&
        dashboardGroup.availableDashboards.length > 0
        ? [
            ...dashboardGroup.availableDashboards,
            {
                _id: CREATE_ACTION_TAB_ID,
                title: localize('@sage/xtrem-ui/create-new-dashboard', '+ Create'),
            },
        ]
        : dashboardGroup.availableDashboards;
    return {
        ...props,
        availableDashboards,
        selectedDashboardId: selectedDashboardId ? String(selectedDashboardId) : undefined,
        setSelectedDashboard: xtremRedux.actions.actionStub,
    };
}, (dispatch, props) => {
    return {
        setSelectedDashboard: (dashboardId) => {
            dispatch(xtremRedux.actions.setSelectedDashboard(dashboardId, props.group, props.contextVariables));
        },
    };
})(DashboardSelectionTabs);
//# sourceMappingURL=dashboard-selection-tabs.js.map