import GlobalStyle from 'carbon-react/esm/style/global-style';
import * as React from 'react';
import { Provider } from 'react-redux';
import * as xtremRedux from '../redux';
import I18nProvider from 'carbon-react/esm/components/i18n-provider';
import { carbonLocale } from '../utils/carbon-locale';
import { ConnectedDashboardComponent } from './dashboard-component';
export class DashboardRootComponent extends React.Component {
    async componentDidMount() {
        const thunkDispatch = xtremRedux.getStore().dispatch;
        await thunkDispatch(xtremRedux.actions.setApplicationContext(this.props.applicationContext));
    }
    componentDidCatch(error) {
        this.setState({ error });
    }
    render() {
        if (this.state?.error) {
            return (React.createElement("div", null,
                React.createElement("h2", null, "Failed to load dashboards."),
                React.createElement("h4", null, this.state.error.message),
                React.createElement("pre", null, this.state.error.stack)));
        }
        return (React.createElement(Provider, { store: xtremRedux.getStore() },
            React.createElement(GlobalStyle, null),
            React.createElement(I18nProvider, { locale: carbonLocale(this.props.applicationContext?.locale ?? 'en-US') },
                React.createElement(ConnectedDashboardComponent, { group: this.props.group }))));
    }
}
//# sourceMappingURL=dashboard-root-component.js.map