import * as React from 'react';
import Preview from 'carbon-react/esm/components/preview';
function DashboardItemPlaceholder({ style }) {
    return (React.createElement("div", { className: "e-dashboard-placeholder-item", style: style },
        React.createElement(Preview, { height: "200px" })));
}
export function DashboardPlaceholder({ isTitlePlaceholderHidden }) {
    const placeHolderItemsStyle = [
        { gridColumn: 'span 4 / auto' },
        { gridColumn: 'span 8 / auto' },
        { gridColumn: 'span 2 / auto' },
        { gridColumn: 'span 6 / auto' },
        { gridColumn: 'span 4 / auto' },
        { gridColumn: 'span 6 / auto' },
        { gridColumn: 'span 3 / auto' },
        { gridColumn: 'span 3 / auto' },
    ];
    return (React.createElement("div", { className: "e-dashboard-placeholder", "data-testid": "e-dashboard-placeholder" },
        !isTitlePlaceholderHidden && (React.createElement("div", { className: "e-dashboard-placeholder-title" },
            React.createElement(Preview, { loading: true, width: "256px" }))),
        React.createElement("div", { className: "e-dashboard-placeholder-body" }, placeHolderItemsStyle.map((itemStyle, index) => (
        // eslint-disable-next-line react/no-array-index-key
        React.createElement(DashboardItemPlaceholder, { key: index, style: itemStyle }))))));
}
//# sourceMappingURL=dashboard-placeholder.js.map