import * as React from 'react';
import type { ApplicationContext, Menu } from '../integration';
import '../render/style/index.scss';
import type { Dict } from '@sage/xtrem-shared';
import './consumer-mock.scss';
import type { QueryParameters } from '../utils/types';
export interface PageMetadata {
    key: string;
    title: string;
}
export interface PageEntry {
    name: string;
    pages: PageMetadata[];
}
export interface ConsumerMockState {
    openPath: string | null;
    isSitemapVisible: boolean;
    siteMap: PageEntry[];
    menuItems: Menu[];
    locale: string;
    username: string;
    userCode?: string;
    isAppDirty: boolean;
    preNavigationConfirmation: (() => Promise<void>) | null;
    openedModules?: Dict<boolean>;
    isPlaySoundEnabled: boolean;
    pageSearch: string;
    error?: Error;
}
export declare class ConsumerMock extends React.Component<{}, ConsumerMockState> {
    private readonly containerRef;
    constructor(props: any);
    componentDidCatch(error: Error): void;
    onInternalNavigate: (path: string, queryParameters?: QueryParameters) => void;
    onMenuChange: (newMenuItems: Menu[]) => void;
    onLocaleChange: (event: React.ChangeEvent<{
        value: string;
    }>) => void;
    onSoundToggleChange: (event: React.ChangeEvent<{
        value: string;
    }>) => void;
    onUserChange: (event: any) => void;
    filterSitemapItems: (page: PageMetadata) => boolean;
    sitemapClick: () => void;
    renderMenuItems: (menuItems: Menu[], isLeft?: boolean) => React.ReactNode;
    openMenuItem: (url: string) => () => Promise<void>;
    onClearPath: () => void;
    onClearTestIds: () => void;
    onShowTestIds: () => void;
    onPageTitleChange: (newTitle: string | null) => void;
    getApplicationContext: () => ApplicationContext;
    onToggleModuleName: (moduleName: string) => () => void;
    renderNavigation: () => React.ReactNode;
    onPageSearch: (searchText: string) => void;
    isPageInModuleAndOpenModule: (moduleEntry: PageEntry, pageSearch: string) => boolean;
    render(): React.ReactNode;
}
//# sourceMappingURL=consumer-mock.d.ts.map