import { ActionPopover, ActionPopoverDivider, ActionPopoverItem, ActionPopoverMenu, } from 'carbon-react/esm/components/action-popover';
import Button from 'carbon-react/esm/components/button';
import ButtonMinor from 'carbon-react/esm/components/button-minor';
import * as React from 'react';
import { connect } from 'react-redux';
import Icon from 'carbon-react/esm/components/icon';
import { localize } from '../../service/i18n-service';
import { noop, slice } from 'lodash';
import IconButton from 'carbon-react/esm/components/icon-button';
import * as tokens from '@sage/design-tokens/js/base/common';
import { MENU_SEPARATOR } from '../control-objects';
import * as ReactDom from 'react-dom';
import Hr from 'carbon-react/esm/components/hr';
import { ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS, SINGLE_INLINE_ACTION_CSS_CLASS } from '../../utils/constants';
function XtremMobilePopoverMenuItem({ item, level = 0, onSelect, isDisabled, }) {
    const [isOpen, setOpen] = React.useState(false);
    if (item === MENU_SEPARATOR) {
        return React.createElement(Hr, { m: 0 });
    }
    if (item.isHidden) {
        return null;
    }
    const props = {
        fullWidth: true,
        buttonType: 'tertiary',
        mt: '8px',
        mb: '8px',
        ml: 0,
        mr: 0,
        iconType: item.icon || 'none',
        'data-testid': item.testId,
        'aria-label': item.title,
        disabled: isDisabled || item.isDisabled,
        key: `${level}_${item.key}`,
        className: item.isDestructive
            ? `e-action-popover-item e-action-popover-item-level-${level} e-action-popover-item-destructive`
            : `e-action-popover-item e-action-popover-item-level-${level}`,
    };
    if (item.childrenProp && item.childrenProp.length > 0) {
        return (React.createElement(React.Fragment, null,
            React.createElement(ButtonMinor, { ...props, onClick: () => setOpen(!isOpen) },
                React.createElement("span", { className: "e-action-popover-item-mobile-label" }, item.title),
                React.createElement(Icon, { type: isOpen ? 'chevron_down' : 'chevron_up' })),
            isOpen &&
                item.childrenProp.map(c => (React.createElement(XtremMobilePopoverMenuItem, { key: `${level}_${item.key}`, item: c, level: level + 1, isDisabled: isDisabled, onSelect: onSelect })))));
    }
    return (React.createElement(ButtonMinor, { ...props, onClick: onSelect(item) },
        React.createElement("span", { className: "e-action-popover-item-mobile-label" }, item.title)));
}
export function XtremActionPopover({ color, isDeviceLessThanSmall, isDisabled, isEditing, isOverSidebar, items, menuRef, noIconSupport, onOpen, pendoId, }) {
    const [isOpen, setIsOpen] = React.useState(false);
    React.useEffect(() => {
        return () => {
            document.body.classList.remove(ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS);
        };
    }, []);
    const getVisibleMenuItems = React.useCallback(() => {
        return items.filter(item => item === MENU_SEPARATOR || !item.isHidden);
    }, [items]);
    const toggleMobileMenu = React.useCallback((event) => {
        event.preventDefault();
        event.stopPropagation();
        if (onOpen) {
            onOpen();
        }
        setIsOpen(o => !o);
    }, [onOpen]);
    const onRecordClick = React.useCallback((item) => (event) => {
        toggleMobileMenu(event);
        if (item.onClick && !isDisabled) {
            item.onClick();
        }
    }, [isDisabled, toggleMobileMenu]);
    const getSingleActionIconButton = React.useCallback((item) => {
        const onAction = (e) => {
            e.preventDefault();
            e.stopPropagation();
            if (item.onClick && !isDisabled) {
                item.onClick();
            }
        };
        return (React.createElement(IconButton, { ref: menuRef, onAction: onAction, disabled: isDisabled || item.isDisabled, 
            // @ts-expect-error tabIndex not included in the carbon IconButton typings
            tabIndex: isDisabled ? -1 : 0, "aria-label": item.title, "data-testid": SINGLE_INLINE_ACTION_CSS_CLASS, className: SINGLE_INLINE_ACTION_CSS_CLASS },
            React.createElement(Icon, { tooltipMessage: item.title, type: item.icon, color: item.isDestructive ? tokens.colorsSemanticNegative500 : tokens.colorsActionMinor500 })));
    }, [isDisabled, menuRef]);
    const getMobileActionButton = React.useCallback(() => {
        const visibleItems = getVisibleMenuItems();
        const hasChildren = (item) => {
            return (item !== MENU_SEPARATOR &&
                !!item.childrenProp &&
                Array.isArray(item.childrenProp) &&
                item.childrenProp.length > 0);
        };
        if (noIconSupport || (visibleItems.length === 1 && hasChildren(visibleItems[0])) || visibleItems.length > 1) {
            return (React.createElement(IconButton, { onAction: toggleMobileMenu, "data-component": "action-popover-button", "data-element": "action-popover-button" },
                React.createElement(Icon, { type: "ellipsis_vertical", color: color })));
        }
        if (visibleItems.length === 1 && visibleItems[0] !== MENU_SEPARATOR) {
            return getSingleActionIconButton(visibleItems[0]);
        }
        return null;
    }, [color, getSingleActionIconButton, getVisibleMenuItems, noIconSupport, toggleMobileMenu]);
    const menuItemReducer = React.useCallback((previousValue, item, index, menuItems) => {
        if (item === MENU_SEPARATOR) {
            // If all previous items are separators, we should not render it at all
            if (!slice(menuItems, 0, index).find(i => i !== MENU_SEPARATOR)) {
                return previousValue;
            }
            // If the last visible item is a separator, we should not render it at all
            if (index === menuItems.length - 1) {
                return previousValue;
            }
            if (menuItems[index + 1] === MENU_SEPARATOR) {
                // If there are multiple separators after each other, we should not render it
                return previousValue;
            }
            previousValue.push(isDeviceLessThanSmall ? (React.createElement("div", { className: "e-action-popover-divider", key: index },
                React.createElement(ActionPopoverDivider, null))) : (React.createElement(ActionPopoverDivider, { key: index })));
            return previousValue;
        }
        const actionPopoverProps = {
            icon: item.icon,
            disabled: isDisabled || item.isDisabled,
            onClick: onRecordClick(item),
            children: React.createElement("span", { "data-testid": item.testId }, item.title),
            key: item.key,
            'data-pendoid': item.pendoId,
        };
        if (item.childrenProp && item.childrenProp.length > 0) {
            const submenu = (React.createElement(ActionPopoverMenu, { key: item.key }, item.childrenProp.reduce(menuItemReducer, [])));
            actionPopoverProps.submenu = submenu;
            actionPopoverProps.onClick = noop;
        }
        actionPopoverProps.className = item.isDestructive ? 'e-action-popover-item-destructive' : undefined;
        const actionPopoverItem = React.createElement(ActionPopoverItem, { ...actionPopoverProps });
        previousValue.push(actionPopoverItem);
        return previousValue;
    }, [isDeviceLessThanSmall, isDisabled, onRecordClick]);
    const createActionPopoverChildren = React.useMemo(() => {
        return getVisibleMenuItems().reduce(menuItemReducer, []);
    }, [getVisibleMenuItems, menuItemReducer]);
    const createActionPopoverChildrenMobile = React.useCallback(() => {
        return (React.createElement("div", { className: "e-action-popover-item-list-wrapper" }, getVisibleMenuItems().map((item, index) => (React.createElement(XtremMobilePopoverMenuItem, { key: item === MENU_SEPARATOR ? `SEP_${index}` : item.key, item: item, isDisabled: isDisabled, level: 0, onSelect: onRecordClick })))));
    }, [getVisibleMenuItems, isDisabled, onRecordClick]);
    const itemHasNoIcon = React.useCallback((item) => {
        return !item.icon || item.icon === 'none';
    }, []);
    const onActionPopoverBlur = React.useCallback(e => {
        if (isEditing) {
            e.stopPropagation();
        }
    }, [isEditing]);
    const onActionPopoverClose = React.useCallback(() => {
        setIsOpen(false);
    }, []);
    const onActionPopoverOpen = React.useCallback(() => {
        /* This timeout is necessary as the carbon ActionPopover submenus are buggy and flickering in first render */
        document.body.classList.add(ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS);
        setIsOpen(true);
        document.body.classList.remove(ACTION_POPOVER_SUBMENUS_COMPAT_CSS_CLASS);
        onOpen?.();
    }, [onOpen]);
    const renderButton = React.useCallback(message => function ActionPopoverButton() {
        return (React.createElement("div", { "data-component": "action-popover-button", "data-element": "action-popover-button", tabIndex: 0, onBlur: onActionPopoverBlur },
            React.createElement(Icon, { ref: menuRef, "aria-label": message, type: "ellipsis_vertical", tooltipMessage: message, color: color })));
    }, [color, menuRef, onActionPopoverBlur]);
    const renderDesktop = React.useCallback(() => {
        const message = localize('@sage/xtrem-ui/action-button-more', 'More Actions');
        const visibleItems = getVisibleMenuItems();
        const visibleItemsNoSeparator = visibleItems.filter(i => i !== MENU_SEPARATOR);
        if (noIconSupport ||
            (visibleItemsNoSeparator.length === 1 &&
                visibleItemsNoSeparator[0].childrenProp &&
                visibleItemsNoSeparator[0].childrenProp.length > 0) ||
            visibleItemsNoSeparator.length > 1 ||
            (visibleItemsNoSeparator.length === 1 && itemHasNoIcon(visibleItemsNoSeparator[0]))) {
            if (isDisabled) {
                return (React.createElement(Button, { iconType: "ellipsis_vertical", disabled: true, "aria-label": message, buttonType: "tertiary", onClick: noop, "data-testid": "e-popover-open" }));
            }
            return (React.createElement(ActionPopover, { "data-pendoid": pendoId, renderButton: renderButton(message), onOpen: onActionPopoverOpen, onClose: onActionPopoverClose }, createActionPopoverChildren));
        }
        if (visibleItemsNoSeparator.length === 1) {
            return React.createElement("div", null, getSingleActionIconButton(visibleItemsNoSeparator[0]));
        }
        return null;
    }, [
        createActionPopoverChildren,
        getSingleActionIconButton,
        getVisibleMenuItems,
        isDisabled,
        itemHasNoIcon,
        noIconSupport,
        onActionPopoverClose,
        onActionPopoverOpen,
        pendoId,
        renderButton,
    ]);
    const renderMobile = React.useCallback(() => {
        const classes = ['e-action-popover-mobile'];
        if (isDeviceLessThanSmall && isOverSidebar) {
            classes.push('e-action-popover-mobile-over-sidebar');
        }
        return (React.createElement(React.Fragment, null,
            isOpen &&
                ReactDom.createPortal(React.createElement("div", { className: classes.join(' ') },
                    React.createElement("div", { className: "e-action-popover-mobile-background", onClick: toggleMobileMenu }),
                    React.createElement("div", { className: "e-action-popover-mobile-content", "data-component": "action-popover" }, createActionPopoverChildrenMobile())), window.document.body),
            React.createElement("div", { className: "e-action-popover-mobile" },
                React.createElement("div", { "data-testid": "e-action-popover-mobile-button", className: "e-action-popover-mobile-button" }, getMobileActionButton()))));
    }, [
        createActionPopoverChildrenMobile,
        getMobileActionButton,
        isDeviceLessThanSmall,
        isOpen,
        isOverSidebar,
        toggleMobileMenu,
    ]);
    if (getVisibleMenuItems().length === 0) {
        return null;
    }
    if (isDeviceLessThanSmall) {
        return renderMobile();
    }
    return renderDesktop();
}
const mapStateToProps = (state, props) => ({
    ...props,
    isDeviceLessThanSmall: state.browser.lessThan.s,
});
export default connect(mapStateToProps)(XtremActionPopover);
//# sourceMappingURL=xtrem-action-popover.js.map