import * as React from 'react';
import type { HasGenericErrorHandler, HasIcon } from '../field/traits';
import type { MenuSeparatorType } from '../control-objects';
import type { TableDropdownActionExternalProps } from './table-shared/table-dropdown-actions/table-dropdown-actions';
export interface XtremActionPopoverItem extends HasIcon, HasGenericErrorHandler<any> {
    key: string;
    title: string;
    onClick: () => void;
    isDisabled?: boolean;
    isHidden?: boolean;
    isDestructive?: boolean;
    testId?: string;
    childrenProp?: Array<XtremActionPopoverItem | MenuSeparatorType>;
    pendoId?: string;
}
export interface XtremActionPopoverExternalProps {
    api?: TableDropdownActionExternalProps['api'];
    color?: string;
    column?: TableDropdownActionExternalProps['column'];
    hasInlineActions?: boolean;
    isDisabled?: boolean;
    isEditing?: TableDropdownActionExternalProps['isEditing'];
    isOverSidebar?: boolean;
    items: Array<XtremActionPopoverItem | MenuSeparatorType>;
    menuRef?: React.MutableRefObject<(HTMLSpanElement & HTMLButtonElement) | null>;
    noIconSupport?: boolean;
    onOpen?: () => void;
    pendoId?: string;
    rowIndex?: TableDropdownActionExternalProps['rowIndex'];
    stopEditing?: TableDropdownActionExternalProps['stopEditing'];
}
export interface XtremActionPopoverProps extends XtremActionPopoverExternalProps {
    isDeviceLessThanSmall: boolean;
}
export declare function XtremActionPopover({ color, isDeviceLessThanSmall, isDisabled, isEditing, isOverSidebar, items, menuRef, noIconSupport, onOpen, pendoId, }: XtremActionPopoverProps): React.ReactNode;
declare const _default: import("react-redux").ConnectedComponent<typeof XtremActionPopover, {
    api?: import("@ag-grid-community/core").GridApi<any> | undefined;
    color?: string | undefined;
    column?: import("@ag-grid-community/core").Column<any> | undefined;
    hasInlineActions?: boolean | undefined;
    isDisabled?: boolean | undefined;
    isEditing?: boolean | undefined;
    isOverSidebar?: boolean | undefined;
    items: ("MENU_SEPARATOR" | XtremActionPopoverItem)[];
    menuRef?: React.MutableRefObject<(HTMLSpanElement & HTMLButtonElement) | null> | undefined;
    noIconSupport?: boolean | undefined;
    onOpen?: (() => void) | undefined;
    pendoId?: string | undefined;
    rowIndex?: number | null | undefined;
    stopEditing?: ((suppressNavigateAfterEdit?: boolean | undefined) => void) | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default _default;
//# sourceMappingURL=xtrem-action-popover.d.ts.map