import CarbonTooltip from 'carbon-react/esm/components/tooltip';
import * as React from 'react';
import { Icon } from '../icon/icon-component';
export function Tooltip({ message, position = 'left', ...props }) {
    return (React.createElement(CarbonTooltip, { message: message, position: position, type: "error" }, props.children));
}
export function TableTooltip(props) {
    return (React.createElement("div", { style: {
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            maxWidth: '24px',
            height: '32px',
        } },
        React.createElement(Icon, { ...props, tooltipMessage: React.createElement("span", { className: "e-ui-table-tooltip-content" }, props.content), color: "#C7384F", type: "error", fontSize: props.fontSize || 'small' })));
}
//# sourceMappingURL=tooltip.js.map