import { get } from 'lodash';
import { getGroupFilterValue } from '../../../service/collection-data-utils';
import { GroupState } from '../../field/table/table-component-types';
export const processGroupSelection = (gridApi, value, row, setSelected) => {
    const groupCondition = getGroupFilterValue({
        group: {
            key: row.__groupKey,
            value: get(row, row.__groupKey),
            aggFunc: row.__aggFunc,
        },
        mode: 'client',
    });
    const conditionValue = groupCondition && typeof groupCondition === 'object' && Object.values(groupCondition).length > 0
        ? Object.values(groupCondition)[0]
        : null;
    const childGroupRows = value.getData({
        where: {
            [row.__groupKey]: conditionValue,
        },
        noLimit: true,
    });
    const selectedChildrens = [];
    gridApi?.forEachNode(rowNode => {
        if (childGroupRows.find(childRow => childRow._id === rowNode.data._id)) {
            selectedChildrens.push(rowNode.data);
            rowNode.setSelected(setSelected, false);
        }
    });
    return selectedChildrens;
};
export const changeGroupIcon = (rowId, groupState, tableRef) => {
    const allGroupStates = [
        { state: GroupState.NOT_SELECTED, cssClass: 'ag-not-selected' },
        { state: GroupState.PARTIAL_SELECTED, cssClass: 'ag-checked ag-partial' },
        { state: GroupState.FULL_SELECTED, cssClass: 'ag-checked' },
    ];
    const currentElement = tableRef.current?.querySelector(`[row-id="${rowId}"] [ref="eWrapper"]`);
    if (currentElement) {
        allGroupStates.forEach(gState => {
            const classes = gState.cssClass.split(' ');
            currentElement.classList.remove(...classes);
        });
        const newGroupState = allGroupStates.find(gState => gState.state === groupState)?.cssClass || '';
        const newClasses = newGroupState.split(' ');
        currentElement.classList.add(...newClasses);
    }
};
export const updateGroupState = (prevSelectedGroupState, groupKey, groupState, isSelected, tableRef) => {
    const prevGroupState = prevSelectedGroupState[groupKey][groupState] || { total: 0 };
    const newCurrentSelected = isSelected
        ? (prevGroupState.currentSelected || 0) + 1
        : (prevGroupState.currentSelected || 0) - 1;
    let newState;
    // The state only can be move to partial if previously we had it FULL Selected.
    if (newCurrentSelected === 0) {
        newState = GroupState.NOT_SELECTED;
    }
    else if (newCurrentSelected < prevGroupState.total) {
        newState = GroupState.PARTIAL_SELECTED;
    }
    else {
        newState = GroupState.FULL_SELECTED;
    }
    changeGroupIcon(`__group-${groupState}`, newState, tableRef);
    return {
        ...prevSelectedGroupState,
        [groupKey]: {
            ...prevSelectedGroupState[groupKey],
            [groupState]: {
                ...prevGroupState,
                state: newState,
                currentSelected: newCurrentSelected,
            },
        },
    };
};
//# sourceMappingURL=table-selection-helper.js.map