import ButtonToggle from 'carbon-react/esm/components/button-toggle/button-toggle.component';
import ButtonToggleGroup from 'carbon-react/esm/components/button-toggle/button-toggle-group';
import { isEqual, kebabCase } from 'lodash';
import React from 'react';
import { connect } from 'react-redux';
import * as xtremRedux from '../../../redux';
import { getRouter } from '../../../service/router';
import { navigationPanelId } from '../../container/navigation-panel/navigation-panel-types';
import { Select } from '../select/select-component';
import { XtremTabs } from '../tabs/xtrem-tabs';
export function TableOptionsMenu({ elementId, onSelectionChange, optionsMenuItems, optionsMenuType = 'dropdown', screenId, selectedOptionsMenuItem, setTableViewOptionsMenuItem, onTelemetryEvent, }) {
    const onChange = React.useCallback((newOptionItem) => {
        if (newOptionItem.graphQLFilter) {
            if (elementId === navigationPanelId) {
                setTableViewOptionsMenuItem(newOptionItem);
            }
            onSelectionChange(newOptionItem);
        }
        else if (newOptionItem.page) {
            getRouter(screenId).goTo(newOptionItem.page);
        }
    }, [onSelectionChange, screenId, setTableViewOptionsMenuItem, elementId]);
    const onDropDownSelected = React.useCallback((selectedItem) => {
        if (!selectedItem) {
            return;
        }
        onTelemetryEvent?.(`tableOptionsMenuSelected-${selectedItem.id}`, {
            screenId,
            id: selectedItem.id,
        });
        const selectedFilter = optionsMenuItems.find(filter => filter.title === selectedItem.id);
        onChange(selectedFilter);
    }, [screenId, optionsMenuItems, onChange, onTelemetryEvent]);
    const onToggleChanged = React.useCallback((_evt, value) => {
        const selectedFilter = optionsMenuItems.find(filter => filter.title === value);
        onChange(selectedFilter);
    }, [optionsMenuItems, onChange]);
    const onTabChanged = React.useCallback((tabId) => {
        const selectedFilter = optionsMenuItems.find(filter => kebabCase(filter.title) === tabId);
        onChange(selectedFilter);
    }, [optionsMenuItems, onChange]);
    const getSelectItems = React.useCallback(() => Promise.resolve(optionsMenuItems.map(option => ({
        id: option.title,
        value: option.title,
        pendoId: option.id ? `tableOptionsMenu-${elementId}-${option.id}` : undefined,
    }))), [elementId, optionsMenuItems]);
    // We should only render the filter selected component if there are more than 1 options.
    if (!selectedOptionsMenuItem || !optionsMenuItems || optionsMenuItems.length < 2) {
        return null;
    }
    if (optionsMenuType === 'dropdown') {
        return (React.createElement("div", { className: "e-option-item-menu", "data-testid": "e-option-item-menu--dropdown", "data-options-menu-type": "dropdown" },
            React.createElement(Select, { getItems: getSelectItems, hasInputSearch: false, initialInputValue: selectedOptionsMenuItem.title, minLookupCharacters: 0, onSelected: onDropDownSelected, selectedItem: { id: selectedOptionsMenuItem.title, value: selectedOptionsMenuItem.title } })));
    }
    if (optionsMenuType === 'tabs') {
        const tabs = optionsMenuItems.map(item => {
            return {
                id: kebabCase(item.title),
                title: item.title,
                icon: item.icon,
            };
        });
        const selectedTabId = kebabCase(selectedOptionsMenuItem?.title || optionsMenuItems[0]?.title);
        return (React.createElement("div", { className: "e-option-item-menu", "data-testid": "e-option-item-menu--tabs", "data-options-menu-type": "tabs" },
            React.createElement(XtremTabs, { onTabChange: onTabChanged, tabs: tabs, selectedTabId: selectedTabId })));
    }
    // In toggle mode, we only render the first 3 items.
    return (React.createElement("div", { className: "e-option-item-menu", "data-testid": "e-option-item-menu--toggle", "data-options-menu-type": "toggle" },
        React.createElement(ButtonToggleGroup, { id: "table-options-toggle-group", name: "table-option-group", value: selectedOptionsMenuItem.title, onChange: onToggleChanged }, optionsMenuItems.slice(0, 3).map((value) => (React.createElement(ButtonToggle, { buttonIcon: value.icon, grouped: true, key: value.title, value: value.title }, value.title))))));
}
const mapStateToProps = (state, props) => {
    const tableViews = state.screenDefinitions[props.screenId]?.tableViews?.[props.elementId];
    const savedTableViewMenuItem = tableViews?.$current?.level?.[0]?.optionsMenuItem;
    if (props.elementId === navigationPanelId && savedTableViewMenuItem) {
        // We check if the selected item still exists on the page
        const selectedItem = props.optionsMenuItems.find(item => isEqual(item, savedTableViewMenuItem));
        return {
            ...props,
            selectedOptionsMenuItem: selectedItem || props.optionsMenuItems?.[0],
            setTableViewOptionsMenuItem: xtremRedux.actions.actionStub,
        };
    }
    return {
        ...props,
        setTableViewOptionsMenuItem: xtremRedux.actions.actionStub,
    };
};
const mapDispatchToProps = (dispatch, props) => {
    return {
        setTableViewOptionsMenuItem: (optionsMenuItem) => {
            dispatch(xtremRedux.actions.setTableViewOptionMenuItem(props.screenId, props.elementId, 0, optionsMenuItem));
        },
    };
};
export const ConnectedTableOptionsMenu = connect(mapStateToProps, mapDispatchToProps)(TableOptionsMenu);
//# sourceMappingURL=table-options-menu.js.map