import React from 'react';
import type { TableDropdownActionsCellProps } from './cell/table-dropdown-action-cell';
import type { InlineCollectionItemAction } from './table-dropdown-actions/table-dropdown-action-types';
interface ResolvedInlineCollectionItemAction extends Omit<InlineCollectionItemAction<any, any>, 'isDisabled' | 'isHidden' | 'isDisplayed' | 'onClick'> {
    key: string;
    isHidden?: boolean;
    isDisabled?: boolean;
    isDisplayed?: boolean;
    onClick?: () => void;
}
interface TableInlineActionsProps {
    inlineActions: Array<ResolvedInlineCollectionItemAction>;
    isEditing?: boolean;
    stopEditing?: TableDropdownActionsCellProps['stopEditing'];
    column?: TableDropdownActionsCellProps['column'];
    api?: TableDropdownActionsCellProps['api'];
    rowIndex?: TableDropdownActionsCellProps['node']['rowIndex'];
    hasDropdownActions?: boolean;
    elementId: string;
    level: number;
}
declare function TableInlineActions({ inlineActions, isEditing }: TableInlineActionsProps): React.ReactElement;
declare const _default: import("react-redux").ConnectedComponent<typeof TableInlineActions, {
    actions?: import("../../types").GridRowActionType | undefined;
    api?: import("@ag-grid-community/core").GridApi<any> | undefined;
    column?: import("@ag-grid-community/core").Column<any> | undefined;
    fieldId: string;
    hasDropdownActions?: boolean | undefined;
    hasInlineActions?: boolean | undefined;
    isDisabled?: boolean | undefined;
    isEditing?: boolean | undefined;
    isPhantomRow?: boolean | undefined;
    level: number;
    onTelemetryEvent?: import("../../../redux/state").OnTelemetryEventFunction | undefined;
    recordId: string;
    rowIndex?: number | null | undefined;
    rowValue: any;
    screenId: string;
    stopEditing?: ((suppressNavigateAfterEdit?: boolean | undefined) => void) | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store<any, import("redux").AnyAction> | undefined;
}>;
export default _default;
//# sourceMappingURL=table-inline-actions.d.ts.map