import Icon from 'carbon-react/esm/components/icon';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import SplitButton from 'carbon-react/esm/components/split-button';
import React from 'react';
import { localize } from '../../../../service/i18n-service';
import { resolveByValue } from '../../../../utils/resolve-value-utils';
import { ConnectedBusinessAction } from '../../../container/footer/business-action';
export const TableCreateActions = React.memo(({ createActions, multiActionType, screenId, elementId }) => {
    const resolvedActions = resolveByValue({
        propertyValue: createActions,
        screenId,
        rowValue: null,
        fieldValue: null,
        skipHexFormat: true,
    });
    const isMultiCreateAction = () => {
        return Array.isArray(resolvedActions) && resolvedActions.length > 1;
    };
    const isSingleCreateAction = () => {
        return Array.isArray(resolvedActions) ? resolvedActions.length === 1 : !!resolvedActions;
    };
    const getSingleCreateAction = () => {
        return Array.isArray(resolvedActions) ? resolvedActions[0] : resolvedActions;
    };
    /**
     * INFO: Carbon's SplitButton accepts an Icon component as it's text prop, but is not typed
     *       accordingly. This function is merely to trick TypeScript ;).
     */
    const getAddIconAsString = () => {
        return (React.createElement(Icon, { type: "add" }));
    };
    if (isMultiCreateAction() && multiActionType === 'multi-action-button') {
        const actions = resolvedActions;
        return (React.createElement(MultiActionButton, { "data-testid": "e-create-multi-action-button", mr: "16px", text: localize('@sage/xtrem-ui/table-create', 'Create') }, actions.map(action => (React.createElement(ConnectedBusinessAction, { id: action.id, defaultButtonType: "tertiary", isSeparated: false, key: action.id, screenId: screenId, skipWrapping: true, pendoId: `createAction-${screenId}-${elementId}-${action.id}` })))));
    }
    if (isMultiCreateAction() && multiActionType === 'split-button') {
        const actions = resolvedActions;
        return (React.createElement(SplitButton, { buttonType: "secondary", "data-testid": "e-create-split-button", size: "small", text: getAddIconAsString() }, actions.map(action => (React.createElement(ConnectedBusinessAction, { id: action.id, defaultButtonType: "tertiary", isSeparated: false, key: action.id, screenId: screenId, skipWrapping: true, pendoId: `createSplitAction-${screenId}-${elementId}` })))));
    }
    if (isSingleCreateAction() && multiActionType === 'multi-action-button') {
        const action = getSingleCreateAction();
        return (React.createElement(ConnectedBusinessAction, { id: action.id, defaultButtonType: "tertiary", isSeparated: true, key: action.id, screenId: screenId, pendoId: `createAction-${screenId}-${elementId}` }));
    }
    // INFO: Create action when rendered in split navigation view.
    if (isSingleCreateAction() && multiActionType === 'split-button') {
        const action = getSingleCreateAction();
        return (React.createElement(ConnectedBusinessAction, { id: action.id, buttonTypeOverride: "secondary", isIconOnly: true, isSeparated: true, key: action.id, screenId: screenId, size: "small", pendoId: `createAction-${screenId}-${elementId}` }));
    }
    return null;
});
TableCreateActions.displayName = 'TableCreateActions';
//# sourceMappingURL=table-create-actions.js.map