import localeText from '../../../../utils/ag-grid/ag-grid-strings';
import { Select } from '../../select/select-component';
import React from 'react';
import { EQUALS, GREATER_THAN, GREATER_THAN_EQUAL, LESS_THAN, LESS_THAN_EQUAL, NOT_EQUALS, RANGE, } from '@sage/xtrem-shared';
/**
 * Component that shows a selector with the options to filter by
 *  */
export function FilterTypeSelect(props) {
    const tableLocaleText = localeText();
    const filterOptions = [
        { id: EQUALS, value: EQUALS, displayedAs: tableLocaleText.equals },
        { id: NOT_EQUALS, value: NOT_EQUALS, displayedAs: tableLocaleText.notEqual },
        { id: LESS_THAN, value: LESS_THAN, displayedAs: tableLocaleText.lessThan },
        { id: GREATER_THAN, value: GREATER_THAN, displayedAs: tableLocaleText.greaterThan },
        { id: LESS_THAN_EQUAL, value: LESS_THAN_EQUAL, displayedAs: tableLocaleText.lessThanOrEqual },
        { id: GREATER_THAN_EQUAL, value: GREATER_THAN_EQUAL, displayedAs: tableLocaleText.greaterThanOrEqual },
        { id: RANGE, value: RANGE, displayedAs: tableLocaleText.inRange },
    ];
    return (React.createElement(Select, { disableOpenOnFocus: true, hasInputSearch: false, getItems: () => Promise.resolve(filterOptions), onChange: props.onChange, selectedItem: filterOptions.find(option => option.id === props.value), size: "small", testId: "e-ui-filter-type" }));
}
//# sourceMappingURL=filter-type-select-component.js.map