import { EQUALS } from '@sage/xtrem-shared';
import { isNil } from 'lodash';
export const isSimpleDateFilter = (filter) => {
    return !Object.prototype.hasOwnProperty.call(filter, 'operator');
};
export const isComplexDateFilter = (filter) => {
    return Object.prototype.hasOwnProperty.call(filter, 'operator');
};
export const defaultDateState = () => ({
    rawValue: '',
    formattedValue: '',
    rawValueTo: '',
    formattedValueTo: '',
    type: EQUALS,
});
export const getModelFromDateState = (dateState) => ({
    filterType: 'date',
    dateFrom: dateState.rawValue,
    dateTo: dateState.rawValueTo,
    type: dateState.type,
    formattedValue: dateState.formattedValue,
    formattedValueTo: dateState.formattedValueTo,
});
export function getDateStateFromModel(model) {
    const value = defaultDateState();
    if (!model || !isSimpleDateFilter(model)) {
        return value;
    }
    if (!isNil(model.dateFrom)) {
        value.rawValue = model.dateFrom;
    }
    if (!isNil(model.dateTo)) {
        value.rawValueTo = model.dateTo;
    }
    if (!isNil(model.formattedValue)) {
        value.formattedValue = model.formattedValue;
    }
    if (!isNil(model.formattedValueTo)) {
        value.formattedValueTo = model.formattedValueTo;
    }
    if (!isNil(model.type)) {
        value.type = model.type;
    }
    return value;
}
//# sourceMappingURL=date-filter-utils.js.map