import * as React from 'react';
import ConnectedTableDropdownActions from '../table-dropdown-actions/table-dropdown-actions';
import ConnectedTableInlineActions from '../table-inline-actions';
import { isNil, noop } from 'lodash';
export function TableDropdownActionsCell(props) {
    const isPhantomRow = React.useMemo(() => props.data?.__phantom !== undefined, [props.data]);
    const onPhantomCellFocus = React.useCallback((e) => {
        e.target?.querySelector?.('button[aria-label="Cancel"]')?.focus?.();
    }, []);
    // Focus phantom row's clear button in non edit mode
    React.useEffect(() => {
        if (!isPhantomRow || props.isEditing) {
            return noop;
        }
        props.eGridCell.addEventListener('focus', onPhantomCellFocus);
        return () => {
            props.eGridCell.removeEventListener('focus', onPhantomCellFocus);
        };
    }, [props.eGridCell, isPhantomRow, onPhantomCellFocus, props.isEditing]);
    if (props.data._id?.startsWith('__group-') || isNil(props.data?._id)) {
        return null;
    }
    const hasInlineActions = props.colDef.cellRendererParams.inlineActions.length > 0 && !isPhantomRow;
    const hasDropdownActions = props.colDef.cellRendererParams.dropdownActions.length > 0 || isPhantomRow;
    return (React.createElement("div", { className: "e-table-field-actions-container", style: props.isEditing
            ? {
                width: Math.max(44, 44 * props.colDef.cellRendererParams.inlineActions.length +
                    44 * Math.sign(props.colDef.cellRendererParams.dropdownActions.length)),
                padding: '0 11px',
                boxSizing: 'border-box',
            }
            : undefined },
        hasInlineActions && (React.createElement(ConnectedTableInlineActions, { actions: props.colDef.cellRendererParams.inlineActions, api: props.api, column: props.column, fieldId: props.colDef.cellRendererParams.elementId, hasDropdownActions: hasDropdownActions, hasInlineActions: hasInlineActions, isDisabled: props.colDef.cellRendererParams.isParentFieldDisabled, isEditing: props.isEditing, isPhantomRow: props.data.__phantom !== undefined, level: props.colDef.cellRendererParams.level, recordId: props.data._id, rowIndex: props.node.rowIndex, rowValue: props.data, screenId: props.colDef.cellRendererParams.screenId, stopEditing: props.stopEditing })),
        hasDropdownActions && (React.createElement(ConnectedTableDropdownActions, { actions: props.colDef.cellRendererParams.dropdownActions, api: props.api, column: props.column, fieldId: props.colDef.cellRendererParams.elementId, hasDropdownActions: hasDropdownActions, hasInlineActions: hasInlineActions, isDisabled: props.colDef.cellRendererParams.isParentFieldDisabled, isEditing: props.isEditing, isPhantomRow: props.data.__phantom !== undefined, level: props.colDef.cellRendererParams.level, recordId: props.data._id, rowIndex: props.node.rowIndex, rowValue: props.data, screenId: props.colDef.cellRendererParams.screenId, stopEditing: props.stopEditing }))));
}
//# sourceMappingURL=table-dropdown-action-cell.js.map