import * as React from 'react';
import type { CellParams } from '../../../../utils/ag-grid/ag-grid-column-config';
import type { MenuSeparatorType } from '../../../control-objects';
import type { DropdownActionItem, Nested } from '../../../field/traits';
import type { NestedCollectionItemAction, NestedCollectionItemActionGroup } from '../table-dropdown-actions/table-dropdown-action-types';
type ActionItemType = DropdownActionItem<any> | NestedCollectionItemAction<any> | MenuSeparatorType | NestedCollectionItemActionGroup<any>;
export interface TableDropdownActionsCellProps extends Omit<CellParams<Nested, any>, 'colDef'> {
    colDef: {
        cellRendererParams: {
            screenId: string;
            elementId: string;
            level: number;
            isParentFieldDisabled: boolean;
            isReadOnly: boolean;
            inlineActions: Array<ActionItemType>;
            dropdownActions: Array<ActionItemType>;
        };
    };
    isEditing: boolean;
}
export declare function TableDropdownActionsCell(props: TableDropdownActionsCellProps): React.ReactElement | null;
export {};
//# sourceMappingURL=table-dropdown-action-cell.d.ts.map