import * as tokens from '@sage/design-tokens/js/base/common';
export const ulDivStyles = ({ hasHelperTextField = false }) => ({
    ...(hasHelperTextField && { top: '-3rem' }),
    position: 'relative',
    width: '100%',
});
export const ulStyles = ({ shouldRenderOptionsAbove = false, hasLookupLinkLine = false, maxHeight = 180, hasCreateNewItemLink = false, }) => {
    let offset = 40;
    if (hasLookupLinkLine) {
        offset += 33;
    }
    if (hasCreateNewItemLink) {
        offset += 33;
    }
    return {
        maxHeight,
        ...((hasLookupLinkLine || hasCreateNewItemLink) &&
            !shouldRenderOptionsAbove && {
            borderTopLeftRadius: tokens.borderRadius050,
            borderTopRightRadius: tokens.borderRadius050,
        }),
        ...((hasLookupLinkLine || hasCreateNewItemLink) &&
            shouldRenderOptionsAbove && {
            borderBottomLeftRadius: tokens.borderRadius050,
            borderBottomRightRadius: tokens.borderRadius050,
        }),
        ...(!hasLookupLinkLine && !hasCreateNewItemLink && { borderRadius: tokens.borderRadius050 }),
        ...(shouldRenderOptionsAbove && {
            borderRadius: '4px',
            bottom: `${offset}px`,
            boxShadow: '0 0px 5px 0 #00141e33, 0 10px 10px 0 #00141e1a',
        }),
    };
};
export const liStyles = ({ isActive = false, isSelected = false } = {}) => {
    return {
        ...(isActive && { backgroundColor: tokens.colorsUtilityMajor050 }),
        ...(isSelected && { fontWeight: 'bold' }),
        padding: '10px 20px 5',
        paddingLeft: '10px',
        paddingRight: '10px',
        whiteSpace: 'pre-wrap',
        flex: 1,
        boxSizing: 'border-box',
    };
};
//# sourceMappingURL=styles.js.map