import Link from 'carbon-react/esm/components/link';
import { noop } from 'lodash';
import React from 'react';
import { localize } from '../../../service/i18n-service';
import { SelectDropDownItem } from './select-dropdown-item';
import { liStyles, ulDivStyles, ulStyles } from './styles';
import { SelectCreateNewItem } from './select-create-new-item';
function NoItemsFound({ fullWidth = false }) {
    return (React.createElement("li", { key: "NOT_FOUND", style: liStyles() },
        React.createElement("div", { className: "e-ui-select-suggestion", "data-testid": "e-ui-select-suggestion" },
            React.createElement("div", { className: "e-ui-select-suggestion-value-wrapper", "data-testid": "e-ui-select-suggestion-value-wrapper" },
                React.createElement("div", { className: "e-ui-select-suggestion-value", "data-testid": "e-ui-select-suggestion-value", style: { ...(!fullWidth && { flex: 1, textAlign: 'left' }) } }, localize('@sage/xtrem-ui/select-component-no-results', 'No items found.'))))));
}
function Loading({ fullWidth }) {
    return (React.createElement("li", { key: "LOADING", style: liStyles() },
        React.createElement("div", { className: "e-ui-select-suggestion", "data-testid": "e-ui-select-suggestion" },
            React.createElement("div", { className: "e-ui-select-suggestion-value-wrapper", "data-testid": "e-ui-select-suggestion-value-wrapper" },
                React.createElement("div", { className: "e-ui-select-suggestion-value", "data-testid": "e-ui-select-suggestion-value", style: { ...(!fullWidth && { flex: 1, textAlign: 'left' }) } }, localize('@sage/xtrem-ui/select-component-loading', 'Loading...'))))));
}
function TypeToSearch({ fullWidth }) {
    return (React.createElement("li", { key: "EMPTY", style: liStyles() },
        React.createElement("div", { className: "e-ui-select-suggestion", "data-testid": "e-ui-select-suggestion" },
            React.createElement("div", { className: "e-ui-select-suggestion-value-wrapper", "data-testid": "e-ui-select-suggestion-value-wrapper" },
                React.createElement("div", { className: "e-ui-select-suggestion-value", "data-testid": "e-ui-select-suggestion-value", style: { ...(!fullWidth && { flex: 1, textAlign: 'left' }) } }, localize('@sage/xtrem-ui/select-component-type-to-search', 'Type to search...'))))));
}
function TypeMoreToSearch({ missingCharacters, fullWidth, }) {
    const emptyMessage = missingCharacters === 1
        ? localize('@sage/xtrem-ui/select-component-type-one-more-character', 'Type 1 more character to search')
        : localize('@sage/xtrem-ui/select-component-type-more-characters', 'Type {{0}} more characters to search', [
            missingCharacters,
        ]);
    return (React.createElement("div", { className: "e-ui-select-suggestion", "data-testid": "e-ui-select-suggestion" },
        React.createElement("div", { className: "e-ui-select-suggestion-value-wrapper", "data-testid": "e-ui-select-suggestion-value-wrapper" },
            React.createElement("div", { className: "e-ui-select-suggestion-value", "data-testid": "e-ui-select-suggestion-value", style: { ...(!fullWidth && { flex: 1, textAlign: 'left' }) } },
                React.createElement("li", { key: "EMPTY", style: liStyles() }, emptyMessage)))));
}
export function SelectDropDown({ addSelectedItem, node, createTunnelLinkText, focusLookupButton, fullWidth = false, getItemProps = () => { }, hasHelperTextField = false, hasHighlightMatchText, hasLookupIcon, highlightedIndex, highlightFirstListItem, highlightLastListItem, inputValue, isItemSelected, isLinkCreateNewText, isMultiSelect = false, isOpen, items, loading, lookupLinkRef, createTunnelLinkRef, maxHeight = 180, menuProps = noop, minLookupCharacters = 3, onCreateNewItemLinkClick, onLookupIconClick, removeSelectedItem, screenId, shouldRenderOptionsAbove, ulRef: externalUlRef, variant = 'carbon', inputId, }) {
    const [listHeight, setListHeight] = React.useState(0);
    const ulRef = externalUlRef ?? React.createRef();
    React.useEffect(() => {
        let resizeObserverEntries = [];
        const observer = new ResizeObserver(entries => {
            resizeObserverEntries = entries;
            setListHeight(entries[0].contentRect.height);
        });
        if (ulRef.current) {
            observer.observe(ulRef.current);
        }
        return () => {
            resizeObserverEntries.forEach(entry => entry.target.remove());
            observer.disconnect();
        };
    }, [ulRef]);
    const renderLinks = () => {
        return (React.createElement(React.Fragment, null,
            hasLookupLinkLine && (React.createElement("div", { className: `e-ui-select-dropdown-lookup-link${!hasCreateNewItemLink ? ' e-ui-select-dropdown-lookup-link-with-radius' : ''}`, style: shouldRenderOptionsAbove
                    ? { bottom: hasCreateNewItemLink ? '73px' : '40px' }
                    : { top: listHeight } },
                React.createElement(Link, { onClick: onLookupIconClick, ref: lookupLinkRef, onKeyDown: onLinkKeyDown }, localize('@sage/xtrem-ui/reference-open-lookup-link', 'View the list')))),
            hasCreateNewItemLink && (React.createElement(SelectCreateNewItem, { ref: createTunnelLinkRef, createTunnelLinkText: createTunnelLinkText, onLinkKeyDown: onLinkKeyDown, onCreateNewItemLinkClick: onInternalCreateNewLinkClick, screenId: screenId, node: node, position: shouldRenderOptionsAbove
                    ? { bottom: '40px' }
                    : {
                        top: hasLookupLinkLine ? `${listHeight + 33}px` : `${listHeight}px`,
                    } }))));
    };
    const renderList = () => {
        if (loading) {
            return React.createElement(Loading, { fullWidth: fullWidth });
        }
        if (!inputValue && minLookupCharacters > 0 && items.length === 0) {
            return React.createElement(TypeToSearch, { fullWidth: fullWidth });
        }
        const missingCharacters = minLookupCharacters - (inputValue?.length ?? 0);
        if (missingCharacters > 0 && items.length === 0) {
            return React.createElement(TypeMoreToSearch, { missingCharacters: missingCharacters, fullWidth: fullWidth });
        }
        if (isOpen && items?.length > 0) {
            const list = items.map((item, index) => {
                const isSelected = isItemSelected({ id: item.id, value: String(item.value) });
                const itemProps = getItemProps({
                    index,
                    item,
                });
                return (React.createElement(SelectDropDownItem, { addSelectedItem: addSelectedItem, fullWidth: fullWidth, isMultiSelect: isMultiSelect, isSelected: isSelected, item: item, hasHighlightMatchText: hasHighlightMatchText, itemProps: itemProps, key: item.id, removeSelectedItem: removeSelectedItem, searchText: inputValue, style: liStyles({
                        isActive: highlightedIndex === index,
                        isSelected,
                    }), variant: variant }));
            });
            if (list.length > 0) {
                return list;
            }
            return React.createElement(NoItemsFound, { fullWidth: fullWidth });
        }
        return React.createElement(NoItemsFound, { fullWidth: fullWidth });
    };
    const onLinkKeyDown = (e) => {
        const linkRefs = {
            lookup: lookupLinkRef,
            createTunnel: createTunnelLinkRef,
        };
        const keys = Object.keys(linkRefs);
        const currentKey = keys.find(key => linkRefs[key].current === e.target);
        if (currentKey) {
            const currentIndex = keys.indexOf(currentKey);
            const nextRef = linkRefs[keys[currentIndex + 1]];
            const prevRef = linkRefs[keys[currentIndex - 1]];
            switch (e.key) {
                case 'ArrowDown':
                    if (nextRef?.current) {
                        nextRef.current.focus();
                    }
                    else {
                        highlightFirstListItem();
                    }
                    break;
                case 'ArrowUp':
                    if (prevRef?.current) {
                        prevRef.current.focus();
                    }
                    else {
                        highlightLastListItem();
                    }
                    break;
                case 'Tab':
                    focusLookupButton();
                    break;
                default:
                    break;
            }
        }
        e.preventDefault();
        e.stopPropagation();
    };
    const onInternalCreateNewLinkClick = React.useCallback((ev) => {
        if (ev.ctrlKey || ev.metaKey) {
            return;
        }
        ev.preventDefault();
        onCreateNewItemLinkClick?.();
    }, [onCreateNewItemLinkClick]);
    const hasLookupLinkLine = hasLookupIcon && isOpen && !loading && !!items?.length;
    const hasCreateNewItemLink = isLinkCreateNewText && isOpen && !loading;
    return (React.createElement("div", { ...menuProps, className: "e-ui-select-dropdown", style: ulDivStyles({ hasHelperTextField }), "aria-busy": !isOpen || loading ? true : undefined, role: undefined },
        React.createElement("ul", { "aria-labelledby": inputId, "data-testid": "e-ui-select-dropdown", ref: ulRef, role: menuProps.role || 'listbox', style: ulStyles({ shouldRenderOptionsAbove, hasLookupLinkLine, maxHeight, hasCreateNewItemLink }) }, !isOpen ? null : renderList()),
        renderLinks()));
}
//# sourceMappingURL=select-dropdown.js.map