import * as React from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { loadPageDialogContent } from '../../redux/actions/dialog-actions';
import { removeScreenDefinition } from '../../redux/actions';
import { isEqual } from 'lodash';
import { getArtifactDescription } from '../../utils/transformers';
import { ContextType } from '../../types';
import PageComponent from '../container/page/page-component';
import Loader from 'carbon-react/esm/components/loader';
/**
 * This component allows us to enable a page to somewhere in the application
 */
export const ScreenComponent = React.memo(({ screenPath, queryParameters, values, onFinish }) => {
    const { name: screenId } = getArtifactDescription(screenPath);
    const dispatch = useDispatch();
    React.useEffect(() => {
        dispatch(loadPageDialogContent(screenPath, queryParameters, values, onFinish));
        return () => {
            dispatch(removeScreenDefinition(screenPath));
        };
    }, [dispatch, screenPath, queryParameters, values, onFinish]);
    const pageDefinition = useSelector(s => s.screenDefinitions[screenId] || null);
    return (React.createElement("div", null,
        !pageDefinition && React.createElement(Loader, { size: "large" }),
        pageDefinition && (React.createElement(PageComponent, { key: screenId, pageDefinition: pageDefinition, contextType: ContextType.dialog, availableColumns: 8 }))));
}, (prevProps, nextProps) => isEqual(prevProps, nextProps));
ScreenComponent.displayName = 'ScreenComponent';
//# sourceMappingURL=screen-component.js.map