import React from 'react';
import IconButton from 'carbon-react/esm/components/icon-button';
import Icon from 'carbon-react/esm/components/icon';
import { localize } from '../../../service/i18n-service';
import Textbox from 'carbon-react/esm/components/textbox';
import { fetchNodeDetails, mapNodeDetailsToTreeProperty } from '../../../service/node-information-service';
import { chain } from 'lodash';
import { getArtifactDescription } from '../../../utils/transformers';
import { Tree } from '@sage/xtrem-ui-components';
export const NodeBrowserTree = React.memo(props => {
    const { node, onCheckedItemsUpdated, filter, checkedItems, isDisabled, isReadOnly, fetchItems: externalFetchItems, locale, } = props;
    const rootElement = React.useMemo(() => node
        ? {
            id: '',
            labelPath: '',
            key: '',
            labelKey: '',
            label: '',
            canBeExpanded: true,
            canBeSelected: false,
            data: {
                kind: 'OBJECT',
                name: '',
                label: '',
                type: getArtifactDescription(node?.toString() || '').name,
                canFilter: true,
                canSort: true,
                node: '',
                enumType: null,
                isCustom: false,
                dataType: '',
                targetNode: '',
                isStored: false,
                isOnInputType: false,
                isOnOutputType: false,
                isMutable: false,
            },
        }
        : null, [node]);
    const fetchItems = React.useCallback(async (treeNode) => {
        if (externalFetchItems) {
            return externalFetchItems(treeNode);
        }
        const allNodeInfo = await fetchNodeDetails({ nodeName: treeNode.data.type, locale });
        let filteredNodes = chain(allNodeInfo).values();
        if (filter) {
            filteredNodes = filteredNodes.thru(filter);
        }
        return mapNodeDetailsToTreeProperty(treeNode, filteredNodes.value());
    }, [externalFetchItems, filter, locale]);
    const [searchText, setSearchText] = React.useState('');
    const inputRef = React.useRef(null);
    const [listOpenedItems, setListOpenedItems] = React.useState({
        key: '',
        children: [],
    });
    const handleOpenChild = React.useCallback((key, children) => {
        setListOpenedItems({ ...listOpenedItems, [key]: children });
    }, [listOpenedItems]);
    const handleCloseChild = React.useCallback((key) => {
        const updatedOpenedItems = { ...listOpenedItems };
        delete updatedOpenedItems[key];
        setListOpenedItems(updatedOpenedItems);
    }, [listOpenedItems]);
    const onClearButtonClicked = React.useCallback(() => {
        setSearchText('');
        if (inputRef?.current) {
            inputRef.current.focus();
        }
    }, [setSearchText, inputRef]);
    const onSearchTextChanged = React.useCallback((ev) => {
        setSearchText(ev.target.value);
    }, []);
    return (rootElement && (React.createElement(React.Fragment, null,
        React.createElement("div", { "data-testid": "e-data-step-search" },
            React.createElement(Textbox, { "data-testid": "e-node-browser-filter", ref: inputRef, onKeyDown: (e) => {
                    // On hitting the enter key the component reloads the page for some reason
                    if (e.key === 'Enter') {
                        e.preventDefault();
                    }
                }, disabled: isDisabled, onChange: onSearchTextChanged, placeholder: localize('@sage/xtrem-ui/reference-lookup-dialog-search-placeholder', 'Search...'), "aria-label": localize('@sage/xtrem-ui/reference-lookup-dialog-search-placeholder', 'Search...'), leftChildren: React.createElement(Icon, { type: "search", bgSize: "large" }), value: searchText, mb: 1 }, !!searchText && (React.createElement(IconButton, { onAction: onClearButtonClicked, "aria-label": localize('@sage/xtrem-ui/clear-filter-text', 'Clear filter text') },
                React.createElement(Icon, { type: "cross" }))))),
        React.createElement("div", { className: "e-data-step-tree-container" },
            React.createElement("div", { className: "e-data-step-tree-wrapper" }, rootElement && (React.createElement(Tree, { checkedItems: checkedItems || {}, element: rootElement, fetchItems: fetchItems, isDisabled: isDisabled, isReadOnly: isReadOnly, level: 0, listOpenedItems: listOpenedItems, localize: localize, onCheckedItemsUpdated: onCheckedItemsUpdated, onCloseChild: handleCloseChild, onOpenChild: handleOpenChild, searchText: searchText })))))));
});
NodeBrowserTree.displayName = 'NodeBrowserTree';
//# sourceMappingURL=node-browser-tree.js.map