import * as React from 'react';
import { localize } from '../../../service/i18n-service';
import { getScreenElement } from '../../../service/screen-base-definition';
import * as xtremRedux from '../../../redux';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import Button from 'carbon-react/esm/components/button';
import { NoRows } from '../svg/no-rows';
import { NoDataFound } from '../svg/no-data-found';
import { getNestedGridContext } from '../../../utils/table-component-utils';
function NoRowsWithButton({ emptyStateText, emptyStateClickableText, onEmptyStateLinkClick, onClick, buttonIconType, }) {
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "e-no-rows-found-component-text" }, emptyStateText ||
            localize('@sage/xtrem-ui/navigation-panel-no-results', 'There are no data to display')),
        emptyStateClickableText && (onClick || onEmptyStateLinkClick) && (React.createElement("div", { className: "e-no-rows-found-component-button" },
            React.createElement(Button, { "data-testid": "e-no-rows-found-component-button", iconType: buttonIconType, m: 0, buttonType: "primary", onClick: onClick || onEmptyStateLinkClick, noWrap: true }, emptyStateClickableText)))));
}
export function EmptyTableComponent({ emptyStateText, emptyStateClickableText, onEmptyStateLinkClick, onRemoveFiltersClick, isTree, screenId = '', isFiltering, level, parentId, isCardView, hasPhantomRow = false, }) {
    const onEmptyStateLinkButtonClick = React.useCallback(() => {
        const state = xtremRedux.getStore().getState();
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        if (onEmptyStateLinkClick) {
            onEmptyStateLinkClick.apply(getScreenElement(pageDefinition), [parentId, level]);
        }
    }, [onEmptyStateLinkClick, level, parentId, screenId]);
    if (isTree) {
        // Empty when group has no children
        return null;
    }
    const className = ['e-table-empty'];
    if (isCardView) {
        className.push('e-table-empty-card');
    }
    if (isFiltering) {
        className.push('e-table-empty-filtering');
        return (React.createElement("div", { className: className.join(' '), "data-testid": "e-no-rows-found-component" },
            !hasPhantomRow && (React.createElement("div", { className: "e-table-no-results-found-image" },
                React.createElement(NoDataFound, { width: isCardView ? 200 : undefined, height: isCardView ? 200 : undefined }))),
            React.createElement("div", { className: "e-table-empty-content-block" },
                React.createElement("div", { className: "e-table-empty-text" }, localize('@sage/xtrem-ui/empty-state-filter-text-title', 'No results found.')),
                React.createElement(NoRowsWithButton, { onClick: onRemoveFiltersClick, emptyStateText: localize('@sage/xtrem-ui/empty-state-filter-text-no-results-description', 'Try different criteria or create a new record to get started.'), emptyStateClickableText: localize('@sage/xtrem-ui/empty-state-filter-text-no-results-button', 'Clear filters'), onEmptyStateLinkClick: onRemoveFiltersClick }))));
    }
    return (React.createElement("div", { className: className.join(' '), "data-testid": "e-no-rows-found-component" },
        !hasPhantomRow && (React.createElement("div", { className: "e-table-empty-rows-image" },
            React.createElement(NoRows, null))),
        React.createElement("div", { className: "e-table-empty-content-block" },
            React.createElement("div", { className: "e-table-empty-text" }, localize('@sage/xtrem-ui/empty-state-text', 'This list has no items yet.')),
            React.createElement(NoRowsWithButton, { onClick: onEmptyStateLinkButtonClick, emptyStateText: emptyStateText, emptyStateClickableText: emptyStateClickableText, onEmptyStateLinkClick: onEmptyStateLinkClick, buttonIconType: "add" }))));
}
/** To be used in ag-grid table */
export function DesktopTableEmptyComponent({ fieldProperties, api, screenId, elementId, isEditable, }) {
    const emptyStateText = fieldProperties?.emptyStateText;
    const emptyStateClickableText = fieldProperties?.emptyStateClickableText;
    const onEmptyStateLinkClick = fieldProperties?.onEmptyStateLinkClick;
    const filter = api?.getFilterModel();
    const isFiltering = filter && Object.keys(filter).length > 0;
    const hasPhantomRow = fieldProperties.canAddNewLine && isEditable;
    const onRemoveFiltersClick = React.useCallback(() => {
        if (api) {
            api.setFilterModel(null);
        }
    }, [api]);
    return (React.createElement(EmptyTableComponent, { elementId: elementId, emptyStateClickableText: emptyStateClickableText, emptyStateText: emptyStateText, isFiltering: isFiltering, onEmptyStateLinkClick: onEmptyStateLinkClick, onRemoveFiltersClick: onRemoveFiltersClick, screenId: screenId, hasPhantomRow: hasPhantomRow }));
}
/** To be used in ag-grid nested grid */
export function DesktopNestedGridEmptyComponent({ fieldProperties, api, screenId, elementId, }) {
    const { level = 0, parentId } = getNestedGridContext(api);
    const emptyStateText = fieldProperties.levels[level].emptyStateText;
    const emptyStateClickableText = fieldProperties.levels[level].emptyStateClickableText;
    const onEmptyStateLinkClick = fieldProperties.levels[level].onEmptyStateLinkClick;
    const filter = api?.getFilterModel();
    const isFiltering = filter && Object.keys(filter).length > 0;
    const onRemoveFiltersClick = React.useCallback(() => {
        if (api) {
            api.setFilterModel(null);
        }
    }, [api]);
    return (React.createElement(EmptyTableComponent, { elementId: elementId, emptyStateClickableText: emptyStateClickableText, emptyStateText: emptyStateText, isFiltering: isFiltering, level: level, onEmptyStateLinkClick: onEmptyStateLinkClick, onRemoveFiltersClick: onRemoveFiltersClick, parentId: parentId, screenId: screenId }));
}
//# sourceMappingURL=no-rows-found-component.js.map