import React from 'react';
import Button from 'carbon-react/esm/components/button';
import { useSelector } from 'react-redux';
import { localize } from '../../../service/i18n-service';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { getElementAccessStatus } from '../../../utils/access-utils';
export function LookupCreateNewItem({ node = '', createTunnelLinkText, onCreateNewItemLinkClick, screenId = '', isDeviceLessThanM, }) {
    const createRight = useSelector(state => {
        if (!node) {
            return null;
        }
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        if (!pageDefinition) {
            return null;
        }
        return (getElementAccessStatus({
            accessBindings: pageDefinition.accessBindings,
            bind: '$create',
            elementProperties: {},
            contextNode: node,
            nodeTypes: state.nodeTypes,
            dataTypes: state.dataTypes,
        }) || null);
    });
    if (createRight !== 'authorized') {
        return null;
    }
    return (React.createElement("div", { className: isDeviceLessThanM
            ? 'e-lookup-dialog-create-new-item-container-mobile'
            : 'e-lookup-dialog-create-new-item-container' },
        React.createElement(Button, { buttonType: "secondary", iconType: "add", "data-testid": "e-lookup-dialog-create-new-item-button", onClick: onCreateNewItemLinkClick }, createTunnelLinkText || localize('@sage/xtrem-ui/lookup-dialog-create-new-item', 'Create new item'))));
}
//# sourceMappingURL=lookup-create-new-item.js.map