import Pill from 'carbon-react/esm/components/pill';
import React from 'react';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import * as tokens from '@sage/design-tokens/js/base/common';
import { isNil } from 'lodash';
import { splitValueToMergedValue } from '../../../utils/transformers';
export const LabelComponent = React.memo((props) => {
    // Value
    const preformattedValue = props.value || ' ';
    let formattedValue = preformattedValue;
    if (props.prefix) {
        const prefix = resolveByValue({
            fieldValue: isNil(props.rawValue) ? preformattedValue : props.rawValue,
            propertyValue: props.prefix,
            rowValue: props.rowValue ? splitValueToMergedValue(props.rowValue) : undefined,
            skipHexFormat: true,
            screenId: props.screenId,
        });
        formattedValue = `${prefix} ${formattedValue}`;
    }
    if (props.postfix) {
        const postfix = resolveByValue({
            fieldValue: isNil(props.rawValue) ? preformattedValue : props.rawValue,
            propertyValue: props.postfix,
            rowValue: props.rowValue ? splitValueToMergedValue(props.rowValue) : undefined,
            skipHexFormat: true,
            screenId: props.screenId,
        });
        formattedValue = `${formattedValue} ${postfix}`;
    }
    // Style
    const style = props.isDisabled
        ? {
            background: tokens.colorsUtilityMajor050,
            borderColor: tokens.colorsUtilityMajor300,
            color: tokens.colorsUtilityMajor300,
            cursor: 'default',
        }
        : {
            backgroundColor: resolveByValue({
                fieldValue: isNil(props.rawValue) ? preformattedValue : props.rawValue,
                propertyValue: props.backgroundColor,
                rowValue: props.rowValue ? splitValueToMergedValue(props.rowValue) : undefined,
                screenId: props.screenId,
            }),
            borderColor: resolveByValue({
                fieldValue: isNil(props.rawValue) ? preformattedValue : props.rawValue,
                propertyValue: props.borderColor,
                rowValue: props.rowValue ? splitValueToMergedValue(props.rowValue) : undefined,
                screenId: props.screenId,
            }),
            color: resolveByValue({
                fieldValue: isNil(props.rawValue) ? preformattedValue : props.rawValue,
                propertyValue: props.color,
                rowValue: props.rowValue ? splitValueToMergedValue(props.rowValue) : undefined,
                screenId: props.screenId,
            }),
            cursor: props.onClick ? 'pointer' : 'default',
        };
    return (React.createElement("span", { className: "e-pill-wrapper" },
        React.createElement(Pill, { fill: false, onClick: props.onClick, style: style, size: props.size || 'M' }, formattedValue)));
});
//# sourceMappingURL=label-component.js.map