import * as React from 'react';
import type { Filter } from '../../../service/filter-service';
import type { FilterManagerField } from './filter-manager';
import type { FilterModel } from '../../field/table/table-component-types';
export interface FilterCommonProps {
    fields: FilterManagerField[];
    filters: Filter[];
    handleSave: (filters: Filter[]) => void;
    isDisabled?: boolean;
    screenId: string;
}
export declare function FiltersComponent({ filters, isDisabled, fields, screenId, handleSave, }: FilterCommonProps): React.ReactElement | null;
interface FilterLabelProps extends FilterCommonProps {
    isNavigationPanel?: boolean;
    filters: Filter[] | FilterModel;
}
interface IPill {
    labelKey: string;
    pillKey: string;
    removePill: Function;
    text: string;
}
export declare const dateFilterNormalization: (filter: FilterModel) => string;
export declare const filterModelToPills: (fields: FilterManagerField[], filters: FilterModel[], removingFn: Function) => IPill[];
export declare function FiltersLabels({ fields, filters, isNavigationPanel, handleSave, }: FilterLabelProps): React.ReactElement | null;
export {};
//# sourceMappingURL=filters-component.d.ts.map