import React, { useState } from 'react';
import { localize } from '../../../service/i18n-service';
import Icon from 'carbon-react/esm/components/icon';
function DragAndDropFile({ children, isDisabled, onFileDrop }) {
    const [isDragging, setIsDragging] = useState(false);
    const dragOverEnterHandler = (e) => {
        e.preventDefault();
        if (e.dataTransfer.items && e.dataTransfer.items[0].kind === 'file') {
            setIsDragging(true);
        }
    };
    const dragLeaveHandler = (e) => {
        e.preventDefault();
        // Check if the related target is a child of the parent div
        if (!e.currentTarget.contains(e.relatedTarget)) {
            setIsDragging(false);
        }
    };
    const dropHandler = (e) => {
        e.preventDefault();
        if (e.dataTransfer.items && e.dataTransfer.items[0].kind === 'file') {
            setIsDragging(false);
            const files = e.dataTransfer.files;
            onFileDrop(files);
        }
    };
    if (isDisabled) {
        return children;
    }
    return (React.createElement("div", { "data-testid": "e-drag-and-drop-component", id: "e-drag-and-drop-component", className: "e-drop-file-container", onDragOver: dragOverEnterHandler, onDragEnter: dragOverEnterHandler, onDragLeave: dragLeaveHandler, onDrop: dropHandler },
        isDragging && (React.createElement("div", { className: "e-drop-file-overlay" },
            React.createElement(Icon, { className: "e-drop-file-upload-icon", fontSize: "extra-large", type: "upload" }),
            React.createElement("p", null, localize('@sage/xtrem-ui/drag-drop-file', 'Drag and drop your files here.')))),
        children));
}
export default DragAndDropFile;
//# sourceMappingURL=drag-and-drop-file.js.map