import type { ClientNode } from '@sage/xtrem-client';
import * as React from 'react';
import type { ScreenBase } from '../../../service/screen-base';
import type { ContextType } from '../../../types';
import type { CollectionItemAction, CollectionItemActionGroup, InlineCollectionItemAction } from '../table-shared/table-dropdown-actions/table-dropdown-action-types';
import type { NestedField, NestedFieldTypes, NestedFieldTypesWithoutTechnical } from '../../nested-fields';
import type { FieldKey } from '../../types';
import type { PortraitPlaceholderMode } from '../portrait-component';
import type { NestedExtensionField } from '../../nested-fields-extensions';
import type { MenuSeparatorType } from '../../container/page/page-types';
export declare const getNestedValue: (value: any, bind: string) => any;
export interface CardDefinition<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
    title: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    titleRight?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line2?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line2Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line3?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line3Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    image?: NestedField<CT, FieldKey.Image | FieldKey.Icon, NodeType>;
    progressBar?: NestedField<CT, FieldKey.Progress, NodeType>;
    [key: string]: NestedField<CT, NestedFieldTypes, NodeType> | undefined;
}
export interface CardExtensionDefinition<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
    title?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    titleRight?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line2?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line2Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line3?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line3Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    image?: NestedExtensionField<CT, FieldKey.Image | FieldKey.Icon, NodeType>;
    [key: string]: NestedExtensionField<CT, NestedFieldTypes, NodeType> | undefined;
}
export interface CardComponentProps<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
    buttonRef?: React.RefObject<HTMLButtonElement>;
    canDrag?: boolean;
    canSelect?: boolean;
    cardDefinition: CardDefinition<CT, any>;
    contextType?: ContextType;
    id?: string;
    isInFocus?: boolean;
    isSelected?: boolean;
    isNewItem?: boolean;
    isDisabled?: boolean;
    imagePlaceholderValue?: string;
    imagePlaceholderMode?: PortraitPlaceholderMode;
    /** If the element is clickable then it is rendered into a button element, if not then into a div element */
    onCardClick?: (recordValue: any, isModifierKeyPushed: boolean) => void;
    onSelect?: (recordValue: any) => void;
    parentElementId: string;
    inlineActions?: Array<InlineCollectionItemAction<ScreenBase>>;
    dropdownActions?: Array<CollectionItemAction<ScreenBase> | CollectionItemActionGroup<ScreenBase> | MenuSeparatorType>;
    screenId: string;
    shouldDisplayAlphabeticalDivider?: boolean;
    value: NodeType;
    isClickIndicatorHidden?: boolean;
}
export declare const CardComponent: React.MemoExoticComponent<(<CT extends ScreenBase<any, any> = ScreenBase<any, any>, NodeType extends ClientNode = any>(props: CardComponentProps<CT, NodeType>) => React.JSX.Element)>;
//# sourceMappingURL=card-component.d.ts.map