import React from 'react';
import { useSelector } from 'react-redux';
import { CardComponent } from '../card/card-component';
import { getEventStyle } from './calendar-body-utils';
export function CalendarEventCardComponent({ elementId, eventProps, selectedView, isMobileMonthlyView, value, screenId, hasClickEventListener, cardColor, eventCard, }) {
    const screenDefinition = useSelector(state => state.screenDefinitions[screenId]);
    if (!screenDefinition || !value || !eventProps.event._def.extendedProps._id) {
        return null;
    }
    const _id = eventProps.event._def.extendedProps._id;
    const record = value.getRecordByIdAndLevel({ id: _id });
    const { eventClasses, style } = getEventStyle(screenId, eventProps, record, hasClickEventListener, cardColor);
    const commonProps = {
        className: eventClasses,
        style,
    };
    if (isMobileMonthlyView) {
        return React.createElement("button", { ...commonProps, type: "button" });
    }
    const cardDefinition = { ...eventCard };
    if (selectedView === 'dayGridMonth') {
        // In monthly view we only display the first line of the card
        Object.keys(cardDefinition).forEach(k => {
            if (k !== 'title' && k !== 'titleRight') {
                delete cardDefinition[k];
            }
        });
    }
    return (React.createElement("div", { className: "e-calendar-event-wrapper" },
        React.createElement("div", { ...commonProps },
            React.createElement(CardComponent, { cardDefinition: cardDefinition, parentElementId: elementId, screenId: screenId, value: record }))));
}
//# sourceMappingURL=calendar-event-component.js.map